% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/removeLayerDictionaryEntry.R
\name{removeLayerDictionaryEntry}
\alias{removeLayerDictionaryEntry}
\title{Removes an entry from a layer dictionary}
\usage{
removeLayerDictionaryEntry(labbcat.url, layer.id, key, entry = NULL)
}
\arguments{
\item{labbcat.url}{URL to the LaBB-CAT instance}

\item{layer.id}{The ID of the layer with a dictionary configured to manage it.}

\item{key}{The key (word) in the dictionary to remove an entry from.}

\item{entry}{The value (definition) for the given key, or NULL to remove all entries
for the given key.}
}
\value{
NULL if the entry was added, or a list of error messages if not.
}
\description{
This function removes an existing entry from the dictionary that manages a given layer,
and updates all affected tokens in the corpus. Words can have multiple entries.
}
\details{
You must have edit privileges in LaBB-CAT in order to be able to use this function.
}
\examples{
\dontrun{
## Remove a pronunciation for "robert" from the phonemes layer dictionary
removeLayerDictionaryEntry(labbcat.url, "phonemes", "robert", "'rQ-bErt")
}

}
\seealso{
Other dictionary functions: 
\code{\link{addDictionaryEntry}()},
\code{\link{addLayerDictionaryEntry}()},
\code{\link{deleteLexicon}()},
\code{\link{getDictionaries}()},
\code{\link{getDictionaryEntries}()},
\code{\link{loadLexicon}()},
\code{\link{removeDictionaryEntry}()}
}
\concept{dictionary functions}
\keyword{annotation}
\keyword{layer}
