% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nparACT_base_loop.R
\name{nparACT_base_loop}
\alias{nparACT_base_loop}
\title{Compute classic non-parametric actigraphy measures for multiple files}
\usage{
nparACT_base_loop(path, SR, cutoff = 1, plot = TRUE, fulldays = TRUE)
}
\arguments{
\item{path}{Character string. Path to the folder containing actigraphy files.}

\item{SR}{Numeric. Sampling rate in Hertz (samples per second).}

\item{cutoff}{Numeric. Activity threshold used to classify movement.
Defaults to 1.}

\item{plot}{Logical. If \code{TRUE}, generates diagnostic plots of the
hourly grand-average activity profiles. Defaults to \code{TRUE}.}

\item{fulldays}{Logical. If \code{TRUE}, data are truncated to include
only complete 24-hour periods. Defaults to \code{TRUE}.}
}
\value{
A data frame with one row per file and the following columns:
\describe{
\item{IS}{Interdaily stability}
\item{IV}{Intradaily variability}
\item{RA}{Relative amplitude}
\item{L5}{Mean activity during the least active 5-hour period}
\item{L5_starttime}{Start time of the L5 period}
\item{M10}{Mean activity during the most active 10-hour period}
\item{M10_starttime}{Start time of the M10 period}
}
}
\description{
Computes the classic non-parametric actigraphy measures:
interdaily stability (IS), intradaily variability (IV),
relative amplitude (RA), as well as the L5 and M10 values
and their respective start times for all actigraphy files in a specified folder.
}
\details{
Each file is expected to contain either two columns (time, activity) or
three columns (date, time, activity). Time variables are internally
converted to \code{POSIXct}. Missing values in the activity signal are
not permitted.

Each file should contain either two columns (time, activity) or three columns (date, time, activity).
Time variables are converted to POSIXct. Missing activity values are not allowed.
The function filters activity, computes minute/hourly averages, calculates IS/IV/RA,
and optionally plots grand-average activity profiles.
}
