% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.mod.lst.R
\name{get.mod.lst}
\alias{get.mod.lst}
\title{Summarize parameter estimates and run information from an nlmixr2 fit}
\usage{
get.mod.lst(fit.s, modi)
}
\arguments{
\item{fit.s}{A model object generated using nlmixr2.}

\item{modi}{A numeric identifier used to label the model results,
for example when multiple models are evaluated in sequence.}
}
\value{
A data.frame with parameter summaries, model fit criteria
(AIC, BIC, objective function value, log-likelihood, number of
estimated parameters) and computation timings extracted from the
fitted object.
}
\description{
Extracts fixed effects, between-subject variability,
residual variability, estimation precision, confidence intervals,
covariance structure, shrinkage, and key runtime metrics from a
fitted model produced by nlmixr2.
}
\details{
The function checks for the presence of each element before
extraction to ensure robust handling of incomplete estimation or
missing covariance results.
}
\examples{
\donttest{
pheno <- function() {
  ini({
    tcl <- log(0.008) # typical value of clearance
    tv <-  log(0.6)   # typical value of volume
    eta.cl + eta.v ~ c(1,
                       0.01, 1) ## cov(eta.cl, eta.v), var(eta.v)
    add.err <- 0.1    # residual variability
  })
  model({
    cl <- exp(tcl + eta.cl) # individual value of clearance
    v <- exp(tv + eta.v)    # individual value of volume
    ke <- cl / v            # elimination rate constant
    d/dt(A1) = - ke * A1    # model differential equation
    cp = A1 / v             # concentration in plasma
    cp ~ add(add.err)       # define error model
  })
}

# Fit the model using nlmixr2
fit <- nlmixr2est::nlmixr2(pheno, pheno_sd, est="saem", nlmixr2est::saemControl(print=0))

# Extract model results
model_results <- get.mod.lst(fit,1)
print(model_results)
}

}
\author{
Zhonghui Huang
}
