% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ztdraw_sc_loglinear.R
\name{ztdraw_sc_loglinear}
\alias{ztdraw_sc_loglinear}
\title{Simulate from a zero-truncated non homogeneous Poisson Point Process (zt-NHPPP) from
(t_min, t_max) with a log-linear intensity function}
\usage{
ztdraw_sc_loglinear(intercept, slope, t_min, t_max, atmost1 = FALSE)
}
\arguments{
\item{intercept}{(double) the intercept in the exponent}

\item{slope}{(double) the slope in the exponent}

\item{t_min}{(double) the lower bound of the time interval}

\item{t_max}{(double) the upper bound of the time interval}

\item{atmost1}{boolean, 1 event time}
}
\value{
a vector of at least 1 event times
}
\description{
Sample zt-NHPPP times from an log-linear intensity function
}
\examples{
x <- ztdraw_sc_loglinear(intercept = 0, slope = 0.2, t_min = 0, t_max = 10)

}
