% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/draw_sc_step_regular.R
\name{draw_sc_step_regular}
\alias{draw_sc_step_regular}
\title{Sampling from NHPPPs with piecewise constant intensities
with same interval lengths (non-vectorized)}
\usage{
draw_sc_step_regular(
  Lambda_vector = NULL,
  lambda_vector = NULL,
  t_min = NULL,
  t_max = NULL,
  atmost1 = FALSE,
  atleast1 = FALSE
)
}
\arguments{
\item{Lambda_vector}{(scalar, double) \code{K} integrated intensity rates at the end of each interval}

\item{lambda_vector}{(scalar, double) \code{K} constant intensity rates, one per interval}

\item{t_min}{(scalar, double) lower bound of the time interval}

\item{t_max}{(scalar, double) upper bound of the time interval}

\item{atmost1}{boolean, draw at most 1 event time}

\item{atleast1}{boolean, draw at least 1 event time}
}
\value{
a vector of event times t
if no events realize, it will have 0 length
}
\description{
Sampling from NHPPPs with piecewise constant intensities
with same interval lengths (non-vectorized)
}
\examples{
x <- draw_sc_step_regular(Lambda_vector = 1:5, t_min = 0, t_max = 5)
}
