% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Clean.R
\name{add_on_ice_players}
\alias{add_on_ice_players}
\title{Add on-ice player IDs to a play-by-play by merging with shift charts}
\usage{
add_on_ice_players(play_by_play, shift_chart)
}
\arguments{
\item{play_by_play}{data.frame of shift chart rows; see \code{\link[=gc_play_by_play]{gc_play_by_play()}}, \code{\link[=gc_play_by_plays]{gc_play_by_plays()}}, \code{\link[=wsc_play_by_play]{wsc_play_by_play()}}, or \code{\link[=wsc_play_by_plays]{wsc_play_by_plays()}} for reference; the original columns must exist}

\item{shift_chart}{data.frame of shift chart rows; see \code{\link[=shift_chart]{shift_chart()}} or \code{\link[=shift_charts]{shift_charts()}} for reference; the original columns must exist}
}
\value{
data.frame with one row per event (play) and added list-columns:
\code{homePlayerIds}, \code{awayPlayerIds}, \code{playerIdsFor}, and \code{playerIdsAgainst}
}
\description{
\code{add_on_ice_players()} merges a play-by-play with a shift chart to determine which players are on the ice at each event. It adds home- and away-team on-ice player ID lists, as well as event-perspective for/against player ID lists when \code{isHome} is available.
}
\examples{
# May take >5s, so skip.
\donttest{gc_pbp_enhanced <- add_on_ice_players(gc_pbp(), shift_chart())}
}
