% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_class.R, R/nifti_extensions.R
\docType{class}
\name{NiftiExtensionList-class}
\alias{NiftiExtensionList-class}
\alias{show,NiftiExtensionList-method}
\title{NiftiExtensionList Class}
\usage{
\S4method{show}{NiftiExtensionList}(object)
}
\arguments{
\item{object}{A \code{\linkS4class{NiftiExtensionList}} object.}
}
\description{
A validated list containing zero or more \code{\link{NiftiExtension-class}} objects.
This class ensures type safety when working with collections of NIfTI extensions.
}
\details{
The class extends \code{list} and enforces that all elements must be
\code{NiftiExtension} objects. This provides a clean container for
managing multiple extensions attached to a NIfTI file.
}
\examples{
# Create an empty extension list
ext_list <- new("NiftiExtensionList")

# Create a list with extensions
ext1 <- NiftiExtension(ecode = 6L, data = "Comment 1")
ext2 <- NiftiExtension(ecode = 6L, data = "Comment 2")
ext_list <- new("NiftiExtensionList", list(ext1, ext2))

}
\seealso{
\code{\link{NiftiExtension-class}} for individual extension objects.
\code{\link{extensions}} for accessing extensions from image objects.
}
