% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_class.R
\docType{class}
\name{MetaInfo-class}
\alias{MetaInfo-class}
\title{MetaInfo Class}
\description{
This class encapsulates meta information for neuroimaging data types,
including spatial and temporal characteristics, data type, and labeling.
}
\details{
The MetaInfo class provides a structured way to store and access essential
metadata for neuroimaging data. This includes information about the data type,
spatial and temporal dimensions, voxel spacing, and coordinate system origin.
}
\section{Slots}{

\describe{
\item{\code{data_type}}{A \code{character} string specifying the data type code (e.g., "FLOAT", "INT").}

\item{\code{dims}}{A \code{numeric} vector representing image dimensions.}

\item{\code{spatial_axes}}{An \code{\linkS4class{AxisSet3D}} object representing image axes for spatial dimensions (x, y, z).}

\item{\code{additional_axes}}{An \code{\linkS4class{AxisSet}} object representing axes for dimensions beyond spatial (e.g., time, color band, direction).}

\item{\code{spacing}}{A \code{numeric} vector representing voxel dimensions in real-world units.}

\item{\code{origin}}{A \code{numeric} vector representing the coordinate origin.}

\item{\code{label}}{A \code{character} vector containing name(s) of images or data series.}
}}

\examples{
# Create a MetaInfo object
meta_info <- new("MetaInfo",
                 data_type = "FLOAT",
                 dims = c(64, 64, 32, 100),
                 spatial_axes = new("AxisSet3D"),
                 additional_axes = new("AxisSet"),
                 spacing = c(3, 3, 4),
                 origin = c(0, 0, 0),
                 label = "fMRI_run1")

}
\seealso{
\code{\link{FileMetaInfo-class}}, \code{\link{AxisSet3D-class}}, \code{\link{AxisSet-class}}
}
