% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrix_conversions.R
\name{as.edgelist.networkLite}
\alias{as.edgelist.networkLite}
\alias{as_tibble.networkLite}
\alias{as.matrix.networkLite}
\title{Convert a \code{networkLite} to a Matrix or \code{tibble}.}
\usage{
\method{as.edgelist}{networkLite}(
  x,
  attrname = NULL,
  output = c("matrix", "tibble"),
  na.rm = TRUE,
  ...
)

\method{as_tibble}{networkLite}(
  x,
  attrnames = (match.arg(unit) == "vertices"),
  na.rm = TRUE,
  ...,
  unit = c("edges", "vertices")
)

\method{as.matrix}{networkLite}(
  x,
  matrix.type = c("adjacency", "incidence", "edgelist"),
  attrname = NULL,
  ...
)
}
\arguments{
\item{x}{A \code{networkLite}.}

\item{attrname}{Name of an edge attribute in \code{x}.}

\item{output}{Type of edgelist to output.}

\item{na.rm}{should missing edges be dropped from edgelist?}

\item{...}{additional arguments}

\item{attrnames}{Vector specifying edge attributes to include in the tibble;
may be logical, integer, or character vector, the former two being
used to select attribute names from \code{list.edge.attributes(x)},
and the latter being used as the attribute names themselves}

\item{unit}{whether to return attributes for edges or for vertices}

\item{matrix.type}{type of matrix to return from
\code{as.matrix.networkLite}}
}
\value{
A \code{matrix} or \code{tibble} (possibly of class \code{edgelist})
constructed from the \code{networkLite}.
}
\description{
Convert a \code{networkLite} to a Matrix or \code{tibble}.
}
