% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cpl.R
\name{fast_cpl}
\alias{fast_cpl}
\title{CPL algorithm for community detection (fast)}
\usage{
fast_cpl(Amat, K, ilabels = NULL, niter = 10)
}
\arguments{
\item{Amat}{adjacency matrix of the network}

\item{K}{desired number of communities}

\item{ilabels}{initial label vector (if not provided, initial labels are
estimated using \link{spec_clust})}

\item{niter}{number of iterations}
}
\value{
Estimated community label vector.
}
\description{
The Conditional Pseudo-Likelihood (CPL) algorithm for fitting
degree-corrected block models
}
\details{
The function implements the CPL algorithm as described in the paper below. It
relies on the \code{mixtools} package for fitting a mixture of multinomials to a
block compression of the adjacency matrix based on the estimated labels and
then reiterates.

Technically, \code{fast_cpl} fits a stochastic block model (SBM) conditional on
the observed node degrees,to account for the degree heterogeneity within
communities that is not modeled well in SBM. CPL can also be used to
effectively estimate the parameters of the degree-corrected block model
(DCSBM).

The code is an adaptation of the original R code by Aiyou Chen with slight
simplifications.
}
\section{References}{
 For more details, see \href{https://projecteuclid.org/euclid.aos/1382547514}{Pseudo-likelihood methods for community detection in large sparse networks}, A. A. Amini, A.
Chen, P. J. Bickel, E. Levina, Annals of Statistics 2013, Vol. 41 (4),
2097—2122.
}

\examples{
head(fast_cpl(igraph::as_adj(polblogs), 2), 50)
}
\keyword{comm_detect}
