% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/neo4j_rmfiles.R
\name{neo4j_rmfiles}
\alias{neo4j_rmfiles}
\title{Remove files from the Neo4J import directory}
\usage{
neo4j_rmfiles(
  local = FALSE,
  con = list(address = NULL, uid = NULL, pwd = NULL),
  files = NULL,
  import_dir = "import"
)
}
\arguments{
\item{local}{Logical indicating whether import is to a locally hosted or remotely hosted server.}

\item{con}{If remotely hosted server, list containing three objects: address, uid, pwd as character strings providing connection to the Neo4J server.
uid and pwd must be for an account on the server with appropriate permissions.}

\item{files}{Character vector of file names to be removed.}

\item{import_dir}{Character string of path to the Neo4J import directory.}
}
\value{
A success message if successful.  An error message otherwise.
}
\description{
Remove files from the Neo4J import directory
}
\examples{
# remove file from local import directory
fs::dir_create("import")
fs::file_create("import/data.csv")
neo4j_rmfiles(local = TRUE, files = "data.csv", import_dir = "import")
fs::dir_delete("import")
}
