% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nbc4va.R
\docType{package}
\name{nbc4va}
\alias{nbc4va}
\title{nbc4va: Bayes Classifier for Verbal Autopsy Data}
\description{
An implementation of the Naive Bayes Classifier (NBC) algorithm
used for Verbal Autopsy (VA) built on code from \href{https://bmcmedicine.biomedcentral.com/articles/10.1186/s12916-015-0521-2}{Miasnikof et al (2015)} <DOI:10.1186/s12916-015-0521-2>.
\cr\cr
For documentation and help, please see:
\cr\cr
\url{https://rrwen.github.io/nbc4va/}
}
\section{Acknowledgements}{

This package was developed at the Centre for Global Health Research (CGHR) in Toronto, Ontario, Canada. The original NBC algorithm code was developed by Pierre Miaskinof and Vasily Giannakeas.
The original performance metrics code was provided by Dr. Mireille Gomes whom also offered guidance in metrics implementation and user testing.
Special thanks to Richard Zehang Li for providing a standard structure for the package and Patrycja Kolpak for user testing of the GUI.
}

\examples{
\dontrun{
library(nbc4va)

# Quick start
# Follow the instructions in the web interface
nbc4vaGUI()

# View user guides for the nbc4va package
browseVignettes("nbc4va")
}

}
\references{
Use \code{citation("nbc4va")} to view citation information for the nbc4va package.
\itemize{
  \item Miasnikof P, Giannakeas V, Gomes M, Aleksandrowicz L, Shestopaloff AY, Alam D, Tollman S, Samarikhalaj, Jha P. Naive Bayes classifiers for verbal autopsies: comparison to physician-based classification for 21,000 child and adult deaths. BMC Medicine. 2015;13:286. doi:10.1186/s12916-015-0521-2.
}
}
\author{
Richard Wen <\email{rrwen.dev@gmail.com}>
}
