% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.trajectory.R
\name{plot.trajectory}
\alias{plot.trajectory}
\title{Plot a \code{trajectory} object}
\usage{
\method{plot}{trajectory}(
  x,
  threeD = FALSE,
  col = "#2980b9",
  col_start = "#e67e22",
  col_end = "#e67e22",
  pch_points_start = 15,
  pch_points_end = 16,
  cex_points = 1.5,
  add_altitude = TRUE,
  n_split = 6,
  plot_end_points = TRUE,
  add_title = TRUE,
  threeD_line_width = 4,
  threeD_line_color = "#008080",
  threeD_col_grad = FALSE,
  threeD_grad_start = "#008080",
  threeD_grad_end = "#ab53cf",
  ...
)
}
\arguments{
\item{x}{A \code{trajectory} object}

\item{threeD}{A \code{boolean} indicating whether the plot should be 3D or 2D (default \code{FALSE}, 2D).}

\item{col}{A \code{string} corresponding to the color of the line used for 2D trajectory (default \code{"blue4"}).}

\item{col_start}{A \code{string} corresponding to the color of the point used to denote the beginning of a 2D trajectory (default \code{"green3"}).}

\item{col_end}{A \code{string} corresponding to the color of the point used to denote the end of a 2D trajectory (default \code{"red2"}).}

\item{pch_points_start}{A \code{numeric} corresponding to the symbol (pch) of the points used to denote the beginning of a 2D trajectory (default \code{15}).}

\item{pch_points_end}{A \code{numeric} corresponding to the symbol (pch) of the points used to denote the end of a 2D trajectory (default \code{16}).}

\item{cex_points}{A \code{numeric} corresponding to the size (cex) of the points used to denote the beginning and the end of a 2D trajectory (default \code{1.5}).}

\item{add_altitude}{A \code{boolean} to indicate if the altitude should be plotted in 2D trajectory in NED system (default \code{TRUE}; altitude is plotted).}

\item{n_split}{A \code{numeric} for the number of ticks in 2D plot with altitude profile, if NULL no ticks are added (default = \code{6}).}

\item{plot_end_points}{A \code{boolean} to indicate if points should be plotted at the beginning and the end of a 2D trajectory (default \code{TRUE}; points are plotted).}

\item{add_title}{A \code{boolean} or \code{string}. If a \code{boolean} is used it indicates if a title should be added to 2D trajectory (only active if name of trajectory exist); if a \code{string} is used it corresponds to the title (default \code{TRUE}).}

\item{threeD_line_width}{A \code{numeric} corresponding to the width of the line for a 3D trajectory (default \code{4}).}

\item{threeD_line_color}{A \code{string} corresponding to the hex color code of the line used for a 3D trajectory (default \code{"#008080"}).}

\item{threeD_col_grad}{A \code{boolean} to indicate if a color gradient should be used for a 3D trajectory (default \code{FALSE}).}

\item{threeD_grad_start}{A \code{string} corresponding to the hex color code for the start of the gradient (default \code{"#008080"}).}

\item{threeD_grad_end}{A \code{string} corresponding to the hex color code for the end of the gradient (default \code{"#ab53cf"}).}

\item{...}{Additional arguments affecting the plot produced.}
}
\value{
A trajectory plot.
}
\description{
Plot a \code{trajectory} object in 2D or 3D.
}
\examples{
n <- 100
set.seed(123)
dat <- cbind(
  seq(from = 0, to = 60 * 60, length.out = n),
  46.204391 * pi / 180 + cumsum(rnorm(n)) / 10^5,
  6.143158 * pi / 180 + cumsum(rnorm(n)) / 10^5,
  375 + cumsum(rnorm(n))
)
traj <- make_trajectory(data = dat, name = "My cool data")
plot(traj)
plot(traj, threeD = TRUE)
plot(traj,
  threeD = TRUE, threeD_line_width = 8,
  threeD_line_color = "#e74c3c"
)
plot(traj,
  threeD = TRUE,
  threeD_col_grad = TRUE
)
plot(traj,
  threeD = TRUE, threeD_col_grad = TRUE,
  threeD_grad_start = "#e74c3c",
  threeD_grad_end = "#d68910"
)

traj <- make_trajectory(data = dat, name = "My cool data", system = "ned")
plot(traj)
plot(traj, col = "orange2", col_start = "pink", col_end = "purple")
plot(traj, pch_points_start = 15, cex_points = 3)
plot(traj, plot_end_points = FALSE)
plot(traj, plot_end_points = FALSE, add_title = FALSE)
}
\author{
Davide Cucci, Lionel Voirol, Mehran Khaghani, Stéphane Guerrier
}
