% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/server.R
\name{handler_inline}
\alias{handler_inline}
\title{Create Inline Static Content Handler}
\usage{
handler_inline(path, data, content_type = NULL, prefix = FALSE)
}
\arguments{
\item{path}{URI path to match (e.g., "/robots.txt").}

\item{data}{Content to serve. Character data is converted to raw bytes.}

\item{content_type}{MIME type (e.g., "text/plain", "application/json").
Defaults to "application/octet-stream" if NULL.}

\item{prefix}{[default FALSE] Logical, if TRUE matches path as a prefix.}
}
\value{
A handler object for use with \code{\link[=http_server]{http_server()}}.
}
\description{
Creates an HTTP handler that serves in-memory static content. Useful for
small files like robots.txt or inline JSON/HTML.
}
\examples{
h1 <- handler_inline("/robots.txt", "User-agent: *\nDisallow:",
                     content_type = "text/plain")
h2 <- handler_inline("/health", '{"status":"ok"}',
                     content_type = "application/json")

}
