\name{predict.multinomial_naive_bayes}
\alias{predict.multinomial_naive_bayes}
\title{Predict Method for multinomial_naive_bayes Objects}
\usage{
\method{predict}{multinomial_naive_bayes}(object, newdata = NULL, type = c("class","prob"), ...)
}
\arguments{
\item{object}{object of class inheriting from \code{"multinomial_naive_bayes"}.}

\item{newdata}{matrix with non-negative integer predictors (only numeric matrix is accepted).}

\item{type}{if "class", new data points are classified according to the highest posterior probabilities. If "prob", the posterior probabilities for each class are returned.}

\item{...}{not used.}
}
\value{
\code{predict.multinomial_naive_bayes} returns either a factor with class labels corresponding to the maximal conditional posterior probabilities or a matrix with class label specific conditional posterior probabilities.
}
\description{
Classification based on the Multinomial Naive Bayes model.
}

\details{
This is a specialized version of the Naive Bayes classifier, where the features represent the frequencies with which events have been generated by a multinomial distribution.

The Multinomial Naive Bayes is not available through the \code{\link{naive_bayes}} function.

The NAs in the newdata are not included into the calculation of posterior probabilities; and if present an informative warning is given.

}

\references{
McCallum, Andrew; Nigam, Kamal (1998). A comparison of event models for Naive Bayes text classification (PDF). AAAI-98 workshop on learning for text categorization. 752. \code{http://www.cs.cmu.edu/~knigam/papers/multinomial-aaaiws98.pdf}
}

\examples{
### Simulate the data:
cols <- 10 ; rows <- 100
M <- matrix(sample(0:5, rows * cols,  TRUE), nrow = rows, ncol = cols)
y <- factor(sample(paste0("class", LETTERS[1:2]), rows, TRUE, prob = c(0.3,0.7)))
colnames(M) <- paste0("V", seq_len(ncol(M)))
laplace <- 1

### Train the Multinomial Naive Bayes
mnb <- multinomial_naive_bayes(x = M, y = y, laplace = laplace)

# Classification
head(predict(mnb, newdata = M, type = "class"))
head(mnb \%class\% M)

# Posterior probabilities
head(predict(mnb, newdata = M, type = "prob"))
head(mnb \%prob\% M)
}
\author{
Michal Majka, \email{michalmajka@hotmail.com}
}
\seealso{
\code{\link{multinomial_naive_bayes}}, \code{\link[naivebayes]{tables}}, \code{\link[naivebayes]{get_cond_dist}}, \code{\link[naivebayes]{\%class\%}}, \code{\link[naivebayes]{coef.multinomial_naive_bayes}}
}

