% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dual-math.R
\name{dual-log}
\alias{dual-log}
\alias{log,dualr-method}
\title{Logarithm with optional base for dual numbers}
\usage{
\S4method{log}{dualr}(x, base = exp(1))
}
\arguments{
\item{x}{A dual number.}

\item{base}{Numeric base (default: \code{exp(1)} for natural log).}
}
\value{
A \code{dual} representing \code{log(x, base)}.
}
\description{
Logarithm with optional base for dual numbers
}
\examples{
x <- dual_variable(8)
value(log(x, base = 2))
deriv(log(x, base = 2))

}
