% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.R
\name{omegaSEM}
\alias{omegaSEM}
\title{Calculate multilevel omega reliability}
\usage{
omegaSEM(items, id, data, savemodel = FALSE)
}
\arguments{
\item{items}{A character vector giving the variables that map
to the items in the scale. Note that these should be reverse
scored prior to running this function.}

\item{id}{A character string giving the name of the variable that
indicates which rows of the dataset belong to the same person
or group for the multilevel analysis.}

\item{data}{A \code{data.table} or \code{data.frame} to be used for analysis.}

\item{savemodel}{A logical value indicating whether the underlying model
should be saved and returned. Defaults to \code{FALSE}.}
}
\value{
a list with two elements, the first, \dQuote{Results} contains the
 estimates for coefficient omega at the within and between level. The
 next element, \dQuote{Fit} contains the entire fitted model from lavaan, if
 \code{savemodel = TRUE}.
}
\description{
This function uses multilevel structural equation modelling
to calculate between and within reliability using coefficient
omega.
}
\examples{
  data(aces_daily, package = "JWileymisc")
  omegaSEM(
    items = c("COPEPrb", "COPEPrc", "COPEExp"),
    id = "UserID",
    data = aces_daily,
    savemodel = FALSE)
}
\references{
Geldhof, G. J., Preacher, K. J., & Zyphur, M. J. (2014)
<doi:10.1037/a0032138>
"Reliability estimation in a multilevel confirmatory factor analysis framework"
}
