% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report-int-data.R
\name{plot-MSA-data}
\alias{plot-MSA-data}
\alias{plot_catch}
\alias{plot_index}
\alias{plot_CAA}
\alias{plot_CAL}
\alias{plot_IAA}
\alias{plot_IAL}
\alias{plot_SC}
\alias{plot_tagmov}
\title{Plotting functions for data in MSA model}
\usage{
plot_catch(fit, f = 1, by = c("region", "stock"), prop = FALSE, annual = FALSE)

plot_index(fit, i = 1, zoom = FALSE)

plot_CAA(fit, f = 1, r = 1, do_mean = FALSE)

plot_CAL(fit, f = 1, r = 1, do_mean = FALSE)

plot_IAA(fit, i = 1, do_mean = FALSE)

plot_IAL(fit, i = 1, do_mean = FALSE)

plot_SC(fit, ff = 1, aa = 1, r = 1, prop = FALSE)

plot_tagmov(fit, s = 1, yy = 1, aa = 1)
}
\arguments{
\item{fit}{\linkS4class{MSAassess} object returned by \code{\link[=fit_MSA]{fit_MSA()}}}

\item{f}{Integer, indexes the fleet}

\item{by}{Character to indicate dimension for multivariate plots}

\item{prop}{Logical, whether to plot proportions (TRUE) or absolute numbers}

\item{annual}{Logical, whether to plot annual values (summed over seasons)}

\item{i}{Integer, indexes the survey}

\item{zoom}{Logical, for \code{plot_index()}. If \code{TRUE}, plots a subset of years with observed data points. Otherwise, plots
predicted values over all model years.}

\item{r}{Integer, indexes the region}

\item{do_mean}{Logical, whether to plot full compositions or time series of mean length or mean age}

\item{ff}{Integer, indexes the aggregate fleet (for stock composition data)}

\item{aa}{Integer, indexes the aggregate age class (for stock composition and tag data)}

\item{s}{Integer, indexes the stock}

\item{yy}{Integer, indexes the aggregate years (for the tag data)}
}
\value{
Various base graphics plots
}
\description{
A set of functions to plot data variables and predicted values (catch, age composition, etc.)
}
\details{
\itemize{
\item \code{plot_catch} plots the fishery catch by stock or region (either whole numbers or proportions)
}

\itemize{
\item \code{plot_index} plots indices of abundance
}

\itemize{
\item \code{plot_CAA} plots the fishery catch at age
}

\itemize{
\item \code{plot_CAL} plots the catch at length
}

\itemize{
\item \code{plot_IAA} plots the index age composition
}

\itemize{
\item \code{plot_IAL} plots the index length composition
}

\itemize{
\item \code{plot_SC} plots the stock composition
}

\itemize{
\item \code{plot_tagmov} plots the tag movements
}
}
