% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make-parameters.R
\name{make_parameters}
\alias{make_parameters}
\alias{make_map}
\alias{check_parameters}
\title{Make list of parameters for RTMB}
\usage{
make_parameters(
  MSAdata,
  start = list(),
  map = list(),
  est_mov = c("none", "dist_random", "gravity_fixed"),
  silent = FALSE,
  ...
)

make_map(
  p,
  MSAdata,
  map = list(),
  est_M = FALSE,
  est_h = FALSE,
  est_mat = FALSE,
  est_sdr = FALSE,
  est_mov = c("none", "dist_random", "gravity_fixed"),
  est_qfs = FALSE,
  silent = FALSE
)

check_parameters(p = list(), map, MSAdata, silent = FALSE)
}
\arguments{
\item{MSAdata}{S4 data object}

\item{start}{An optional list of parameters. Named list of parameters with the associated dimensions and transformations below.
Overrides default values created by \code{\link[=make_parameters]{make_parameters()}}.}

\item{map}{List of mapped parameters. Used by \code{\link[=check_parameters]{check_parameters()}} only to count parameters.}

\item{est_mov}{Character describing structure of stock movement parameters. Only used if map arguments for the movement parameters is NULL. See details below.}

\item{silent}{Logical, whether \code{\link[=make_map]{make_map()}} reports messages to the console}

\item{...}{Various arguments for \code{\link[=make_map]{make_map()}} (could be important!)}

\item{p}{List of parameters, e.g., returned by \code{\link[=make_parameters]{make_parameters()}}}

\item{est_M}{Logical, estimate natural mortality? Only used if \code{map$log_M_s} is NULL}

\item{est_h}{Logical, estimate steepness? Only used if \code{map$t_h_s} is NULL}

\item{est_mat}{Logical, estimate maturity? Only used if \code{map$mat_ps} is NULL}

\item{est_sdr}{Logical, estimate standard deviation of recruitment deviates? Only used if \code{map$log_sdr_s} is NULL}

\item{est_qfs}{Logical, estimate relative catchability of stocks by each fleet? Fix \code{log_q_fs} for the first stock if \code{TRUE}. Only used if \code{map$log_q_fs} is NULL}
}
\value{
\code{\link[=make_parameters]{make_parameters()}} returns a list of parameters (\code{"p"}) concatenated with the output of \code{\link[=make_map]{make_map()}}.

\code{\link[=make_map]{make_map()}} returns a named list containing parameter mappings (\code{"map"}) and a character vector of random effects (\code{"random"}).

\code{\link[=check_parameters]{check_parameters()}} invisibly returns the parameter list if no problems are encountered.
}
\description{
Sets up the list of parameters, map of parameters (see \code{map} argument in \code{\link[TMB:MakeADFun]{TMB::MakeADFun()}}), and identifies some random effects parameters
based on the input data and some user choices on model configuration.

These functions provide a template for the parameter and map setup that can be adjusted for alternative configurations. \code{\link[=check_parameters]{check_parameters()}}
checks whether custom made parameter lists are of the correct dimension.
}
\section{Parameters}{


Generally parameter names will have up to three components, separated by underscores.
For example, \code{log_M_s} represents the natural logarithm of natural mortality, and is a vector by stock \code{s}.

The first component describes the transformation from the estimated parameter space to the normal parameter space,
frequently, \code{log} or \code{logit}. Prefix \code{t} indicates some other custom transformation that is described below.

Second is the parameter name, e.g., \code{M} for natural mortality, \code{rdev} for recruitment deviates, etc.

Third is the dimension of the parameter variable and the indexing for the vectors, matrices, and arrays, e.g., \code{y} for year, \code{s} for stock.
See \linkS4class{MSAdata}. Here, an additional index \code{p} represents some other number of parameters that is described below.

\describe{
\item{\code{t_R0_s}}{Vector by \code{s}. Unfished recruitment, i.e., intersection of unfished replacement line and average stock recruit function,
is represented as: \code{R0_s <- exp(t_R0_s) * MSAdata@Dmodel@scale_s}. By default, \code{t_R0_s = 3}}
\item{\code{t_h_s}}{Vector by \code{s}. Steepness of the stock-recruit function. Logit space for Beverton-Holt and log space for Ricker functions.
Default steepness value of 0.8}
\item{\code{mat_ps}}{Matrix \verb{[2, s]}. Maturity parameters (can be estimated or specified in data object). Logistic functional form. The
parameter in the first row is the age of 50 percent maturity in logit space: \code{a50_s <- plogis(mat_ps[1, ] * na)}.
In the second row is the age of 95 percent maturity as a logarithmic offset: \code{a95_s <- a50_s + exp(mat_ps[2, ])}.
Default \code{a50_s <- 0.5 * na} and \code{a95_s <- a50_s + 1}}
\item{\code{log_M_s}}{Vector by \code{s}. Natural logarithm of natural mortality (can be estimated or specified in data object).
Default parameter value for all stocks: \code{M <- -log(0.05)/MSAdata@Dmodel@na}}
\item{\code{log_rdev_ys}}{Matrix \verb{[y, s]}. Log recruitment deviations. By default, all start values are at zero.}
\item{\code{log_sdr_s}}{Vector by \code{s}. log-Standard deviation of the log recruitment deviations. Default SD = 0.4}
\item{\code{log_q_fs}}{Matrix \verb{[f, s]}. The natural logarithm of \code{q_fs}, the relative fishing efficiency of \code{f} for stock \code{s}.
Equal values imply equal catchability of all stocks. See equations in \code{\link[=calc_F]{calc_F()}}. Default sets all values to zero.}
\item{\code{log_Fdev_ymfr}}{Array \verb{[y, m, f, r]}. Fishing mortality parameters. For each fleet, the log of F is estimated directly for the
reference year, season, region. For other strata, F is an offset from this value:
\deqn{
F_{y,m,f,r} = \begin{cases}
\exp(x^{\textrm{Fmult}}_f) \quad & y = y_{\textrm{ref}}, m = m_{\textrm{ref}}, r = r_{\textrm{ref}}\\
\exp(x^{\textrm{Fmult}}_f + x^{\textrm{Fdev}}_{y,m,r}) \quad & \textrm{otherwise}
\end{cases}
}
}
\item{\code{sel_pf}}{Matrix \verb{[3, f]}. Fishery selectivity parameters in logit or log space. See equations \code{\link[=conv_selpar]{conv_selpar()}}, where \code{sel_pf} is the \code{x} matrix.}
\item{\code{sel_pi}}{Matrix \verb{[3, i]}. Index selectivity parameters in logit or log space. See equations \code{\link[=conv_selpar]{conv_selpar()}}, where \code{sel_pi} is the \code{x} matrix.}
\item{\code{mov_x_marrs}}{Array \verb{[m, a, r, r, s]}. Base movement matrix. Set to -1000 to effectively exclude movements from region pairs.
See equations in \code{\link[=conv_mov]{conv_mov()}}}
\item{\code{mov_g_ymars}}{Array \verb{[y, m, a, r, s]}. Attractivity term in gravity model for movement. If \code{x} and \code{v} are zero,
this matrix specifies the distribution of total stock abundance into the various regions. See equations in \code{\link[=conv_mov]{conv_mov()}}}
\item{\code{mov_v_ymas}}{Array \verb{[y, m, a, s]}. Viscosity term in gravity model for movement. See equations in \code{\link[=conv_mov]{conv_mov()}}}
\item{\code{log_sdg_rs}}{Array \verb{[r, s]}. Marginal log standard deviation in the stock distribution (\code{mov_g_ymars}) among regions for stock \code{s}.
Only used when \code{est_mov = "dist_random"}. Default SD of 0.1.}
\item{\code{t_corg_ps}}{Array \verb{[sum(1:(nr - 1)), s]}. Lower triangle of the correlation matrix for \code{mov_g_ymars}, to be obtained with the
Cholesky factorization. Only used when \code{est_mov = dist_random}. Default values of zero.}
\item{\code{log_initF_mfr}}{Array \verb{[m, f, r]}. Initial F corresponding to the equilibrium catch.}
\item{\code{log_initrdev_as}}{Array \verb{[na - 1, s]}. Recruitment deviations for the initial abundance-at-age vector.}
}
}

\section{Start list}{

Users can provide \code{R0_s} and \code{h_s} in the start list. \code{\link[=make_parameters]{make_parameters()}} will make the appropriate transformation for the starting values
of \code{t_R0_s} and \code{t_h_s}, respectively.
}

\section{Movement setup for \code{make_map()}}{

If a single region model or \code{est_mov = "none"}: no movement parameters are estimated.

If \code{est_mov = "dist_random"}: fix all values for \code{mov_x_marrs} and \code{mov_v_ymas}. Fix \code{mov_g_ymars} for the first region for each year,
season, age, and stock. \code{mov_g_ymars} are random effects.

If \code{est_mov = "gravity_fixed"}: fix all values for \code{mov_x_marrs}. Fix \code{mov_g_ymars} for the first region for each year,
season, age, and stock. Estimate all \code{mov_v_ymas}. Both \code{mov_g_ymars} and \code{mov_v_ymas} are fixed effects.

By default \code{p$mov_x_marrs} is zero. Set to -1000 for areas for which there is no abundance of a particular stock.
}

\seealso{
\linkS4class{MSAdata}
}
