#' Initialize an empty parameter vector
#'
#' The parameter vector is used to hold the initial values of the model parameters
#'
#' @keywords internal
resetParamVector = function() {
  k = nIndices()
  pkgEnv$param = rep(NA, k)
  pkgEnv$names = cbind(hazard=rep(NA, k),
                       component=rep(NA, k),
                       parameter=rep(NA, k))
}

#' Set names for a part of the parameter vector
#'
#' Assign values to a subset of the elements of the parameter vector
#'
#' @param indices the indices to set
#' @param hazard hazard label
#' @param component component label
#' @param param parameter label
#'
#' @keywords internal
setParamNames = function(indices, hazard, component, param) {
  pkgEnv$names[indices,'hazard'] = hazard
  pkgEnv$names[indices,'component'] = component
  pkgEnv$names[indices,'parameter'] = param
}


#' Set a part of the parameter vector
#'
#' Assign values to a subset of the elements of the parameter vector
#'
#' @param indices the indices to set
#' @param value the values to set
#'
#' @keywords internal
setParamVector = function(indices, value) {
  pkgEnv$param[indices] = value
}


#' Return the parameter vector
#'
#' @return a numeric vector
#' @keywords internal
paramVector = function() {
  return(pkgEnv$param)
}