% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/confint.LORgee.R
\name{confint.LORgee}
\alias{confint.LORgee}
\alias{confint}
\title{Confidence Intervals for Model Parameters}
\usage{
\method{confint}{LORgee}(object, parm, level = 0.95, method = "robust",
  ...)
}
\arguments{
\item{object}{a fitted model LORgee object.}

\item{parm}{a specification of which parameters are to be given confidence
intervals, either a vector of numbers or a vector of names. If missing, all
parameters are considered.}

\item{level}{the confidence level required.}

\item{method}{character indicating whether the sandwich (robust) covariance
matrix (\code{method = "robust"}) or the model--based (naive) covariance
matrix (\code{method = "naive"}) should be used for calculating the
confidence intervals.}

\item{...}{additional argument(s) for methods.}
}
\value{
A matrix (or vector) with columns giving lower and upper confidence
limits for each parameter. These will be labelled as \code{(1-level)/2} and
\code{1 - (1-level)/2} in \% (by default 2.5\% and 97.5\%).
}
\description{
Computes confidence intervals for one or more parameters in a fitted LORgee
model.
}
\details{
The (Wald-type) confidence intervals are calculated using either the
sandwich (robust) or the model-based (naive) covariance matrix.
}
\examples{
fitmod <- ordLORgee(formula = y ~ factor(time) + factor(trt) + factor(baseline),
  data = arthritis, id = id, LORstr = "uniform", repeated = time)
confint(fitmod)

}
