% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/count_motifs.R
\name{exemplify_motif}
\alias{exemplify_motif}
\title{Returns an example for a motif found in a given network}
\usage{
exemplify_motif(net, motif, lvl_attr = "sesType", directed = NULL)
}
\arguments{
\item{net}{network object}

\item{motif}{motif identifier string for the motif}

\item{lvl_attr}{character vector specifying the attribute name where level
information is stored in \code{net}.}

\item{directed}{whether the graph shall be treated as a directed graph. Per
default (\code{NULL}), this is determined automatically using the structure
of the provided network object}
}
\value{
vector of nodes in the motif
}
\description{
Returns an example for a motif found in a given network
}
\examples{
\dontrun{
exemplify_motif(ml_net, motif = "1,2[I.C]", directed = FALSE)
}
}
\seealso{
\code{motifr::show_motif}
}
