% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/names.R
\name{mn_join_by_name}
\alias{mn_join_by_name}
\title{Join data to boundaries by (normalized) names}
\usage{
mn_join_by_name(data, name_col, level = "ADM1", boundaries = NULL)
}
\arguments{
\item{data}{Data frame with a name column.}

\item{name_col}{Column in \code{data} that contains names to join on.}

\item{level}{Boundary level, passed to \code{mn_boundaries()} if \code{boundaries} not provided.}

\item{boundaries}{Optional pre-fetched boundaries.}
}
\value{
sf with joined data.
}
\description{
Join data to boundaries by (normalized) names
}
\examples{
\dontshow{if (curl::has_internet()) withAutoprint(\{ # examplesIf}
pop_data <- data.frame(aimag = c("Ulaanbaatar", "Darkhan-Uul"), pop = c(1500000, 100000))
sf_joined <- mn_join_by_name(pop_data, "aimag", level = "ADM1")
\dontshow{\}) # examplesIf}
}
