% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotFunctions.R
\name{plotBoot}
\alias{plotBoot}
\alias{plot.bootNet}
\title{Plot \code{bootNet} outputs}
\usage{
plotBoot(
  x,
  type = "edges",
  net = "temporal",
  plot = "all",
  cor = 0.7,
  order = "mean",
  ci = 0.95,
  pairwise = TRUE,
  interactions = TRUE,
  labels = NULL,
  title = NULL,
  cis = "quantile",
  true = NULL,
  errbars = FALSE,
  vline = FALSE,
  threshold = FALSE,
  difference = FALSE,
  color = FALSE,
  text = FALSE,
  textPos = "value",
  multi = NULL,
  directedDiag = FALSE,
  ...
)

\method{plot}{bootNet}(
  x,
  type = "edges",
  net = "temporal",
  plot = "all",
  cor = 0.7,
  order = "mean",
  ci = 0.95,
  pairwise = TRUE,
  interactions = TRUE,
  labels = NULL,
  title = NULL,
  cis = "quantile",
  true = NULL,
  errbars = FALSE,
  vline = FALSE,
  threshold = FALSE,
  difference = FALSE,
  color = FALSE,
  text = FALSE,
  textPos = "value",
  multi = NULL,
  directedDiag = FALSE,
  ...
)
}
\arguments{
\item{x}{Output from \code{\link{bootNet}}. Also some compatiblity with
\code{resample} objects (when sampMethod != 'stability').}

\item{type}{The outcome measure to plot. Options include: \code{"edges",
  "strength", "ei", "outstrength", "instrength", "outei", "inei"}. The "out-"
and "in-" options are only available for temporal networks. Moreover, both
related options can be used together in temporal networks, by setting
either \code{type = c("outstrength", "instrength")} or \code{type =
  c("outei", "inei")}.}

\item{net}{Determines which network to plot coefficients for. Options
include: \code{"ggm", "temporal", "contemporaneous", "between"}. Only
relevant to SUR networks or \code{mlGVAR} objects.}

\item{plot}{Primary use is to set as \code{"none"} or \code{FALSE} in order
to return a table containing the constituents of the plot rather than
create the plot itself. The options \code{"all"} and \code{"both"} each
essentially indicate that both pairwise and interaction terms are plotted.
Can also specify \code{"pairwise"} to only plot the pairwise terms, or
\code{"interactions"} to only plot the interaction terms.}

\item{cor}{Numeric value to indicate the correlation stability value to be
plotted. Only applies to the case-drop bootstrapping output.}

\item{order}{Determines how to arrange the predictors displayed in the plot.
If \code{TRUE}, then defaults to \code{"mean"}. If \code{FALSE} then
defaults to \code{"id"}. The \code{"mean"} option will arrange the values
by the bootstrapped sample means. The \code{"sample"} option will arrange
the values according to the statistics from the model fitted to the full
sample. The \code{"id"} option will keep the variables in the same order
that they appear in the dataframe. Not relevant to the case-drop bootstrap.}

\item{ci}{Numeric value between 0 and 1 to specify the confidence level.}

\item{pairwise}{Logical. Whether to plot pairwise relationships. Defaults to
\code{TRUE}. If \code{FALSE}, this will override the \code{"all"} option of
the \code{plot} argument.}

\item{interactions}{Logical. Whether to plot interactions. Defaults to
\code{TRUE}. If \code{FALSE}, this will override the \code{"all"} option of
the \code{plot} argument. Only relevant to moderated networks.}

\item{labels}{Logical. Determines whether to plot names of the predictors.}

\item{title}{Character vector the title label.}

\item{cis}{Either \code{"quantile"} or \code{"se"}. If \code{"quantile"},
then confidence bands will be computed based on quantiles (specified by the
\code{ci} argument) of the bootstrapped resamples. If \code{"se"}, then the
confidence bands will be computed based on the standard errors associated
with the sample statistics. Thus, the \code{"se"} argument will always
produce a symmetric confidence band, whereas for \code{"quantile"} argument
this is not necessary. Not relevant to outputs for the case-drop bootstrap.}

\item{true}{Defaults to \code{NULL}, not relevant for the case-drop
bootstrap. Can supply another output from \code{\link{fitNetwork}}, or an
adjacency matrix, to serve as the true network in the plot. If there are
interactions in the model, then a \code{\link{fitNetwork}} object is
recommended. Alternatively, this argument can be extremely useful for
simulated data -- especially anything created with \code{\link{simNet}}.
For whatever outcome (e.g., \code{edges, strength, EI}) is plotted,
supplying another object to \code{true} will plot the values related to the
true network, i.e., the data-generating model.}

\item{errbars}{Logical. Not relevant to the case-drop bootstrap. If
\code{TRUE}, then error bars are used rather than confidence bands. Can be
useful to home in on specific variables and see their confidence interval.}

\item{vline}{Logical or numeric. Not relevant to the case-drop bootstrap. If
\code{TRUE}, then a dashed vertical line will be plotted at 0. If numeric,
then the line will be plotted at the supplied intercept on the x-axis.}

\item{threshold}{Numeric or logical. Not relevant to the case-drop bootstrap.
Has a significant effect on the bootstrapped coefficient distributions. If
\code{TRUE}, then the default p-value threshold is set to .05. A numeric
value can specify a different threshold. Causes the \code{\link{bootNet}}
function to run the object again, only to re-compute the bootstrapped
distributions after applying a p-value threshold to the results of each
model iteration. If \code{NULL}, all coefficient estimates are used in
estimating the posterior distribution of each parameter.}

\item{difference}{Logical. Not relevant to the case-drop bootstrap. If
\code{TRUE}, then a difference plot is provided rather than a coefficient
plot. In the difference plot, the diagonal squares reflect the fitted
network coefficients for the the original sample. Black boxes indicate that
the difference between the two edges, coefficients, or centrality values
being compared is significantly different from 0. The significance level
will have already been determined by the parameters used to fit the
\code{bootNet} object. Gray boxes indicate the difference is not
significantly different from 0.}

\item{color}{Logical. Only applies when \code{difference = TRUE}. Determines
whether to add colors that reflect the sign of the sample values. Reflected
in the diagonal of the difference plot.}

\item{text}{Logical. For difference plots, if \code{TRUE} then the statistics
based on the full sample will be labeled in the diagonal boxes. For
coefficient plots, setting this to \code{TRUE} will plot a label for each
variable to reflect the proportion of times that it was selected across all
bootstrapped iterations. Only relevant if a threshold was set for the
fitted bootstrap models, either specified in the current function or was
specified in creating the \code{\link{bootNet}} object. If a numeric value
is provided, this will determine the size of the text label. Defaults to
1.2 when \code{text = TRUE}.}

\item{textPos}{Supports the \code{text} argument for coefficient plots.
Indicates the x-axis position of where to plot the coefficient labels.
Generally will be numeric, but defaults to \code{"value"}, which means that
the text will be labeled on top each point on the plot.}

\item{multi}{Useful when there are interactions in a model. If \code{TRUE},
the single plot with a facet for both pairwise and interaction terms is
split into two separate plots. Allows for a more elegant side-by-side plot,
and allows arguments that are restricted for plots of either pairwise or
interactions (such as \code{text}) are plotted. This argument will
eventually be expanded to allow one to plot combinations of edge and
centrality plots.}

\item{directedDiag}{See corresponding argument in the \code{\link{bootNet}}.
function.}

\item{...}{Additional arguments.}
}
\value{
A coefficient plot, difference plot, or correlation-stability plot.
When \code{plot \%in\% c('none', FALSE)}, the table used to construct the
relevant plot will be returned as output instead.
}
\description{
Creates various types of plot to visualize \code{bootNet} objects.
}
\examples{
\donttest{
boot1 <- bootNet(ggmDat, caseDrop = TRUE)

plot(boot1)
plotBoot(boot1) # This functions the same as the command above

boot2 <- bootNet(ggmDat)

plot(boot2)
plot(boot2, difference = TRUE)
}
}
\seealso{
\code{\link{bootNet}, \link{resample}}
}
