% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/learner_surv_coxph_cox.R
\name{LearnerSurvCoxPHCox}
\alias{LearnerSurvCoxPHCox}
\title{R6 Class to construct a Cox proportional hazards survival learner}
\description{
The \code{LearnerSurvCoxPHCox} class is the interface to perform a Cox
regression with the \code{survival} R package for use with the \code{mlexperiments}
package.
}
\details{
Can be used with
\itemize{
\item \link[mlexperiments:MLCrossValidation]{mlexperiments::MLCrossValidation}
}
}
\examples{
# survival analysis
if (requireNamespace("survival", quietly = TRUE) &&
requireNamespace("glmnet", quietly = TRUE) &&
requireNamespace("splitTools", quietly = TRUE)) {

  dataset <- survival::colon |>
    data.table::as.data.table() |>
    na.omit()
  dataset <- dataset[get("etype") == 2, ]

  seed <- 123
  surv_cols <- c("status", "time", "rx")

  feature_cols <- colnames(dataset)[3:(ncol(dataset) - 1)]

  split_vector <- splitTools::multi_strata(
    df = dataset[, .SD, .SDcols = surv_cols],
    strategy = "kmeans",
    k = 4
  )

  train_x <- model.matrix(
    ~ -1 + .,
    dataset[, .SD, .SDcols = setdiff(feature_cols, surv_cols[1:2])]
  )
  train_y <- survival::Surv(
    event = (dataset[, get("status")] |>
               as.character() |>
               as.integer()),
    time = dataset[, get("time")],
    type = "right"
  )

  fold_list <- splitTools::create_folds(
    y = split_vector,
    k = 3,
    type = "stratified",
    seed = seed
  )


  surv_coxph_cox_optimizer <- mlexperiments::MLCrossValidation$new(
    learner = LearnerSurvCoxPHCox$new(),
    fold_list = fold_list,
    ncores = 1L,
    seed = seed
  )
  surv_coxph_cox_optimizer$performance_metric <- c_index

  # set data
  surv_coxph_cox_optimizer$set_data(
    x = train_x,
    y = train_y
  )

  surv_coxph_cox_optimizer$execute()
}


## ------------------------------------------------
## Method `LearnerSurvCoxPHCox$new`
## ------------------------------------------------

if (requireNamespace("survival", quietly = TRUE)) {
  LearnerSurvCoxPHCox$new()
}

}
\seealso{
\code{\link[survival:coxph]{survival::coxph()}}
}
\section{Super class}{
\code{\link[mlexperiments:MLLearnerBase]{mlexperiments::MLLearnerBase}} -> \code{LearnerSurvCoxPHCox}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-LearnerSurvCoxPHCox-new}{\code{LearnerSurvCoxPHCox$new()}}
\item \href{#method-LearnerSurvCoxPHCox-clone}{\code{LearnerSurvCoxPHCox$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="mlexperiments" data-topic="MLLearnerBase" data-id="bayesian_scoring_function"><a href='../../mlexperiments/html/MLLearnerBase.html#method-MLLearnerBase-bayesian_scoring_function'><code>mlexperiments::MLLearnerBase$bayesian_scoring_function()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlexperiments" data-topic="MLLearnerBase" data-id="cross_validation"><a href='../../mlexperiments/html/MLLearnerBase.html#method-MLLearnerBase-cross_validation'><code>mlexperiments::MLLearnerBase$cross_validation()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlexperiments" data-topic="MLLearnerBase" data-id="fit"><a href='../../mlexperiments/html/MLLearnerBase.html#method-MLLearnerBase-fit'><code>mlexperiments::MLLearnerBase$fit()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlexperiments" data-topic="MLLearnerBase" data-id="predict"><a href='../../mlexperiments/html/MLLearnerBase.html#method-MLLearnerBase-predict'><code>mlexperiments::MLLearnerBase$predict()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LearnerSurvCoxPHCox-new"></a>}}
\if{latex}{\out{\hypertarget{method-LearnerSurvCoxPHCox-new}{}}}
\subsection{Method \code{new()}}{
Create a new \code{LearnerSurvCoxPHCox} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LearnerSurvCoxPHCox$new()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A new \code{LearnerSurvCoxPHCox} R6 object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{if (requireNamespace("survival", quietly = TRUE)) {
  LearnerSurvCoxPHCox$new()
}

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LearnerSurvCoxPHCox-clone"></a>}}
\if{latex}{\out{\hypertarget{method-LearnerSurvCoxPHCox-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LearnerSurvCoxPHCox$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
