% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fairness_tensor.R
\name{fairness_tensor}
\alias{fairness_tensor}
\alias{fairness_tensor.data.table}
\alias{fairness_tensor.PredictionClassif}
\alias{fairness_tensor.ResampleResult}
\title{Compute the Fairness Tensor given a Prediction and a Task}
\usage{
fairness_tensor(object, normalize = "all", ...)

\method{fairness_tensor}{data.table}(object, normalize = "all", task, ...)

\method{fairness_tensor}{PredictionClassif}(object, normalize = "all", task, ...)

\method{fairness_tensor}{ResampleResult}(object, normalize = "all", ...)
}
\arguments{
\item{object}{(\code{\link[data.table:data.table]{data.table::data.table()}} | \link[mlr3:PredictionClassif]{mlr3::PredictionClassif} | \link[mlr3:ResampleResult]{mlr3::ResampleResult})\cr
A data.table with columns \code{truth} and \code{prediction},
a \link[mlr3:PredictionClassif]{mlr3::PredictionClassif} or a \link[mlr3:ResampleResult]{mlr3::ResampleResult}.}

\item{normalize}{(\code{character})\cr
How should the fairness tensor be normalized?
"all" normalizes entries by dividing by dataset size,
"group" normalizes entries by dividing by group size and
"none" does not conduct any normalization at all.}

\item{...}{\code{any}\cr
Currently not used.}

\item{task}{(\link[mlr3:TaskClassif]{mlr3::TaskClassif})\cr
A \link[mlr3:TaskClassif]{mlr3::TaskClassif}. Needs \code{col_role} \code{"pta"} to be set.}
}
\value{
\code{list()} of confusion matrix for every group in \code{"pta"}.
}
\description{
A fairness tensor is a list of groupwise confusion matrices.
}
\section{Protected Attributes}{

The protected attribute is specified as a \code{col_role} in the corresponding \code{\link[mlr3:Task]{mlr3::Task()}}:\cr
\verb{<Task>$col_roles$pta = "name_of_attribute"} \cr
This also allows specifying more than one protected attribute,
in which case fairness will be considered on the level of intersecting groups defined by all columns
selected as a predicted attribute.
}

\examples{
\dontshow{if (rlang::is_installed("rpart")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library("mlr3")
task = tsk("compas")
prediction = lrn("classif.rpart")$train(task)$predict(task)
fairness_tensor(prediction, task = task)
\dontshow{\}) # examplesIf}
}
