% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ml_qda.R
\name{mlQda}
\alias{mlQda}
\alias{ml_qda}
\alias{mlQda.formula}
\alias{mlQda.default}
\alias{predict.mlQda}
\title{Supervised classification using quadratic discriminant analysis}
\usage{
mlQda(train, ...)

ml_qda(train, ...)

\method{mlQda}{formula}(formula, data, ..., subset, na.action)

\method{mlQda}{default}(train, response, ...)

\method{predict}{mlQda}(
  object,
  newdata,
  type = c("class", "membership", "both"),
  prior = object$prior,
  method = c("plug-in", "predictive", "debiased", "looCV", "cv"),
  ...
)
}
\arguments{
\item{train}{a matrix or data frame with predictors.}

\item{...}{further arguments passed to \code{\link[MASS:qda]{MASS::qda()}} or its  \code{\link[=predict]{predict()}}
method (see the corresponding help page).}

\item{formula}{a formula with left term being the factor variable to predict
and the right term with the list of independent, predictive variables,
separated with a plus sign. If the data frame provided contains only the
dependent and independent variables, one can use the \code{class ~ .} short
version (that one is strongly encouraged). Variables with minus sign are
eliminated. Calculations on variables are possible according to usual
formula convention (possibly protected by using \code{I()}).}

\item{data}{a data.frame to use as a training set.}

\item{subset}{index vector with the cases to define the training set in use
(this argument must be named, if provided).}

\item{na.action}{function to specify the action to be taken if \code{NA}s are
found. For \code{\link[=ml_qda]{ml_qda()}} \code{na.fail} is used by default. The calculation is
stopped if there is any \code{NA} in the data. Another option is \code{na.omit},
where cases with missing values on any required variable are dropped (this
argument must be named, if provided). For the \code{predict()} method, the
default, and most suitable option, is \code{na.exclude}. In that case, rows with
\code{NA}s in \verb{newdata=} are excluded from prediction, but reinjected in the
final results so that the number of items is still the same (and in the
same order as \verb{newdata=}).}

\item{response}{a vector of factor for the classification.}

\item{object}{an \strong{mlQda} object}

\item{newdata}{a new dataset with same conformation as the training set (same
variables, except may by the class for classification or dependent variable
for regression). Usually a test set, or a new dataset to be predicted.}

\item{type}{the type of prediction to return. \code{"class"} by default, the
predicted classes. Other options are \code{"membership"} the membership (a
number between 0 and 1) to the different classes, or \code{"both"} to return
classes and memberships.}

\item{prior}{the prior probabilities of class membership. By default, the
prior are obtained from the object and, if they where not changed,
correspond to the proportions observed in the training set.}

\item{method}{\code{"plug-in"}, \code{"predictive"}, \code{"debiased"}, \code{"looCV"}, or
\code{"cv"}. \code{"plug-in"} (default) the usual unbiased parameter estimates are
used. With \code{"predictive"}, the parameters are integrated out using a vague
prior. With \code{"debiased"}, an unbiased estimator of the log posterior
probabilities is used. With \code{"looCV"}, the leave-one-out cross-validation
fits to the original data set are computed and returned. With \code{"cv"},
cross-validation is used instead. If you specify \code{method = "cv"} then
\code{\link[=cvpredict]{cvpredict()}} is used and you cannot provide \verb{newdata=} in that case.}
}
\value{
\code{\link[=ml_qda]{ml_qda()}}/\code{\link[=mlQda]{mlQda()}} creates an \strong{mlQda}, \strong{mlearning} object
containing the classifier and a lot of additional metadata used by the
functions and methods you can apply to it like \code{\link[=predict]{predict()}} or
\code{\link[=cvpredict]{cvpredict()}}. In case you want to program new functions or extract
specific components, inspect the "unclassed" object using \code{\link[=unclass]{unclass()}}.
}
\description{
Unified (formula-based) interface version of the quadratic discriminant
analysis algorithm provided by \code{\link[MASS:qda]{MASS::qda()}}.
}
\examples{
# Prepare data: split into training set (2/3) and test set (1/3)
data("iris", package = "datasets")
train <- c(1:34, 51:83, 101:133)
iris_train <- iris[train, ]
iris_test <- iris[-train, ]
# One case with missing data in train set, and another case in test set
iris_train[1, 1] <- NA
iris_test[25, 2] <- NA

iris_qda <- ml_qda(data = iris_train, Species ~ .)
summary(iris_qda)
confusion(iris_qda)
confusion(predict(iris_qda, newdata = iris_test), iris_test$Species)

# Another dataset (binary predictor... not optimal for qda, just for test)
data("HouseVotes84", package = "mlbench")
house_qda <- ml_qda(data = HouseVotes84, Class ~ ., na.action = na.omit)
summary(house_qda)
}
\seealso{
\code{\link[=mlearning]{mlearning()}}, \code{\link[=cvpredict]{cvpredict()}}, \code{\link[=confusion]{confusion()}}, also \code{\link[MASS:qda]{MASS::qda()}} that
actually does the classification.
}
