% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ml_naive_bayes.R
\name{mlNaiveBayes}
\alias{mlNaiveBayes}
\alias{ml_naive_bayes}
\alias{mlNaiveBayes.formula}
\alias{mlNaiveBayes.default}
\alias{predict.mlNaiveBayes}
\title{Supervised classification using naive Bayes}
\usage{
mlNaiveBayes(train, ...)

ml_naive_bayes(train, ...)

\method{mlNaiveBayes}{formula}(formula, data, laplace = 0, ..., subset, na.action)

\method{mlNaiveBayes}{default}(train, response, laplace = 0, ...)

\method{predict}{mlNaiveBayes}(
  object,
  newdata,
  type = c("class", "membership", "both"),
  method = c("direct", "cv"),
  na.action = na.exclude,
  threshold = 0.001,
  eps = 0,
  ...
)
}
\arguments{
\item{train}{a matrix or data frame with predictors.}

\item{...}{further arguments passed to the classification method or its
\code{\link[=predict]{predict()}} method (not used here for now).}

\item{formula}{a formula with left term being the factor variable to predict
and the right term with the list of independent, predictive variables,
separated with a plus sign. If the data frame provided contains only the
dependent and independent variables, one can use the \code{class ~ .} short
version (that one is strongly encouraged). Variables with minus sign are
eliminated. Calculations on variables are possible according to usual formula
convention (possibly protected by using \code{I()}).}

\item{data}{a data.frame to use as a training set.}

\item{laplace}{positive number controlling Laplace smoothing for the naive
Bayes classifier. The default (0) disables Laplace smoothing.}

\item{subset}{index vector with the cases to define the training set in use
(this argument must be named, if provided).}

\item{na.action}{function to specify the action to be taken if \code{NA}s are
found. For \code{\link[=ml_naive_bayes]{ml_naive_bayes()}} \code{na.fail} is used by default. The calculation is
stopped if there is any \code{NA} in the data. Another option is \code{na.omit},
where cases with missing values on any required variable are dropped (this
argument must be named, if provided). For the \code{predict()} method, the
default, and most suitable option, is \code{na.exclude}. In that case, rows with
\code{NA}s in \verb{newdata=} are excluded from prediction, but reinjected in the
final results so that the number of items is still the same (and in the
same order as \verb{newdata=}).}

\item{response}{a vector of factor with the classes.}

\item{object}{an \strong{mlNaiveBayes} object}

\item{newdata}{a new dataset with same conformation as the training set (same
variables, except may by the class for classification or dependent variable
for regression). Usually a test set, or a new dataset to be predicted.}

\item{type}{the type of prediction to return. \code{"class"} by default, the
predicted classes. Other options are \code{"membership"}, the posterior
probability or \code{"both"} to return classes and memberships,}

\item{method}{\code{"direct"} (default) or \code{"cv"}. \code{"direct"} predicts new cases in
\verb{newdata=} if this argument is provided, or the cases in the training set
if not. Take care that not providing \verb{newdata=} means that you just
calculate the \strong{self-consistency} of the classifier but cannot use the
metrics derived from these results for the assessment of its performances.
Either use a different dataset in \verb{newdata=} or use the alternate
cross-validation ("cv") technique. If you specify \code{method = "cv"} then
\code{\link[=cvpredict]{cvpredict()}} is used and you cannot provide \verb{newdata=} in that case.}

\item{threshold}{value replacing cells with probabilities within 'eps' range.}

\item{eps}{number for specifying an epsilon-range to apply Laplace smoothing
(to replace zero or close-zero probabilities by 'threshold').}
}
\value{
\code{\link[=ml_naive_bayes]{ml_naive_bayes()}}/\code{\link[=mlNaiveBayes]{mlNaiveBayes()}} creates an \strong{mlNaiveBayes},
\strong{mlearning} object containing the classifier and a lot of additional
metadata used by the functions and methods you can apply to it like
\code{\link[=predict]{predict()}} or \code{\link[=cvpredict]{cvpredict()}}. In case you want to program new functions or
extract specific components, inspect the "unclassed" object using
\code{\link[=unclass]{unclass()}}.
}
\description{
Unified (formula-based) interface version of the naive Bayes algorithm
provided by \code{\link[e1071:naiveBayes]{e1071::naiveBayes()}}.
}
\examples{
# Prepare data: split into training set (2/3) and test set (1/3)
data("iris", package = "datasets")
train <- c(1:34, 51:83, 101:133)
iris_train <- iris[train, ]
iris_test <- iris[-train, ]
# One case with missing data in train set, and another case in test set
iris_train[1, 1] <- NA
iris_test[25, 2] <- NA

iris_nb <- ml_naive_bayes(data = iris_train, Species ~ .)
summary(iris_nb)
predict(iris_nb) # Default type is class
predict(iris_nb, type = "membership")
predict(iris_nb, type = "both")
# Self-consistency, do not use for assessing classifier performances!
confusion(iris_nb)
# Use an independent test set instead
confusion(predict(iris_nb, newdata = iris_test), iris_test$Species)

# Another dataset
data("HouseVotes84", package = "mlbench")
house_nb <- ml_naive_bayes(data = HouseVotes84, Class ~ .,
  na.action = na.omit)
summary(house_nb)
confusion(house_nb) # Self-consistency
confusion(cvpredict(house_nb), na.omit(HouseVotes84)$Class)
}
\seealso{
\code{\link[=mlearning]{mlearning()}}, \code{\link[=cvpredict]{cvpredict()}}, \code{\link[=confusion]{confusion()}}, also
\code{\link[e1071:naiveBayes]{e1071::naiveBayes()}} that actually does the classification.
}
