% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setMetadata.R
\name{setMetadata}
\alias{setMetadata}
\alias{getMetadata}
\title{Set metadata for a model}
\usage{
setMetadata(params, title, description, authors, url, doi, ...)

getMetadata(params)
}
\arguments{
\item{params}{The MizerParams object for the model}

\item{title}{A string with the title for the model}

\item{description}{A string with a description of the model. This could for
example contain information about any publications using the model.}

\item{authors}{An author entry or a list of author entries, where each author
entry could either be just a name or could itself be a list with fields
like \code{name}, \code{orcid}, possibly \code{email}.}

\item{url}{A URL where more information about the model can be found. This
could be a blog post on the mizer blog, for example.}

\item{doi}{The digital object identifier for your model. To create a doi you
can use online services like https://zenodo.org/ or https://figshare.com.}

\item{...}{Additional metadata fields that you would like to add}
}
\value{
\code{setMetadata()}: The MizerParams object with updated metadata

\code{getMetadata()}: A list with all metadata entries that have been set,
including at least
\code{mizer_version}, \code{extensions}, \code{time_created} and \code{time_modified}.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
Setting metadata is particularly important for sharing your model with
others. All metadata fields are optional and you can also add other fields
of your own choosing. If you set a value
for a field that already existed, the old value will be overwritten.
}
\details{
In addition to the metadata fields you can set by hand, there are four fields
that are set automatically by mizer:
\itemize{
\item \code{mizer_version} The version string of the mizer version under which the
model was created or last upgraded. Can be compared to the current version
which is obtained with \code{packageVersion("mizer")}. The purpose of this field
is that if the model is not working as expected in the current version of
mizer, you can go back to the older version under which presumably it was
working.
\item \code{extensions} A named vector of strings where each name is the name of and
extension package needed to run the model and each value is a string giving
the information that the remotes package needs to install the correct version
of the extension package, see https://remotes.r-lib.org/. This field is
set by the extension packages.
\item \code{time_created} A POSIXct date-time object with the creation time.
\item \code{time_modified} A POSIXct date-time object with the last modified time.
}

Setting the metadata with this function does not count as a modification of
the object, so the \code{time_modified} field will not be updated.
}
