% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qp_solver.R
\name{qp_solver}
\alias{qp_solver}
\title{General Solver for Quadratic Programming Problems}
\usage{
qp_solver(n, A, b, c, x_max = 1, method = "GA", print_message = FALSE, ...)
}
\arguments{
\item{n}{An integer representing the number of decision variables.}

\item{A}{A matrix representing the quadratic coefficients.}

\item{b}{A numeric vector representing the linear coefficients.}

\item{c}{A numeric scalar representing the constant term in the objective function.}

\item{x_max}{An integer representing the upper bound for the decision variables. Default is 1.}

\item{method}{A character string specifying the optimization method to use. Can be \code{'GA'}, \code{'DEoptim'}, or \code{'nloptr'}.}

\item{print_message}{A logical value indicating whether to print optimization details. Default is FALSE.}

\item{...}{Additional control parameters passed to the chosen optimization method.}
}
\value{
A list containing:
\item{f_cd}{The optimal objective function value.}
\item{x_value}{The optimal values of the decision variables.}
}
\description{
This function provides a general interface to solve quadratic programming problems using different optimization methods.
It supports Genetic Algorithm (GA), Differential Evolution (DEoptim), and Sequential Least Squares Programming (SLSQP).
}
\seealso{
\code{\link{qp_solver_DEoptim}}, \code{\link{qp_solver_GA}}, \code{\link{qp_solver_nloptr}}
}
