% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataset.R
\name{gdataset.example_path}
\alias{gdataset.example_path}
\title{Create an example dataset on the fly}
\usage{
gdataset.example_path()
}
\value{
Path to the created dataset directory (in a temporary location)
}
\description{
Creates a small dataset in a temporary directory using the built-in
example database. This function has side effects: it calls
\code{\link{gdb.init_examples}} which resets the working database, and
it creates then deletes temporary tracks ('example_dataset_track') and
intervals ('example_dataset_intervals') in that database.
}
\details{
This function performs the following steps:
\enumerate{
  \item Calls \code{gdb.init_examples()} to set the working database
  \item Removes any existing 'example_dataset_track' and 'example_dataset_intervals'
  \item Creates temporary track and intervals in the example database
  \item Saves them to a new dataset in a temporary directory
  \item Removes the temporary track and intervals from the example database
}

This is primarily intended for use in examples and tests. Users should be
aware that calling this function will change their current working database.
}
\examples{
\dontshow{
options(gmax.processes = 2)
}

dataset_path <- gdataset.example_path()
gdataset.load(dataset_path)
gdataset.unload(dataset_path)

}
\seealso{
\code{\link{gdataset.save}}, \code{\link{gdataset.load}},
  \code{\link{gdb.init_examples}}
}
