% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute-distribution.R
\name{gcis_decay}
\alias{gcis_decay}
\title{Calculates distribution of contact distances}
\usage{
gcis_decay(
  expr = NULL,
  breaks = NULL,
  src = NULL,
  domain = NULL,
  intervals = NULL,
  include.lowest = FALSE,
  iterator = NULL,
  band = NULL
)
}
\arguments{
\item{expr}{track expression}

\item{breaks}{breaks that determine the bin}

\item{src}{source intervals}

\item{domain}{domain intervals}

\item{intervals}{genomic scope for which the function is applied}

\item{include.lowest}{if 'TRUE', the lowest value of the range determined by
breaks is included}

\item{iterator}{2D track expression iterator. If 'NULL' iterator is
determined implicitly based on track expressions.}

\item{band}{track expression band. If 'NULL' no band is used.}
}
\value{
2-dimensional vector representing the distribution of contact
distances for inter and intra domains.
}
\description{
Calculates distribution of contact distances.
}
\details{
A 2D iterator interval '(chrom1, start1, end1, chrom2, start2, end2)' is
said to represent a contact between two 1D intervals I1 and I2: '(chrom1,
start1, end1)' and '(chrom2, start2, end2)'.

For contacts where 'chrom1' equals to 'chrom2' and I1 is within source
intervals the function calculates the distribution of distances between I1
and I2. The distribution is calculated separately for intra-domain and
inter-domain contacts.

An interval is within source intervals if the unification of all source
intervals fully overlaps it. 'src' intervals are allowed to contain
overlapping intervals.

Two intervals I1 and I2 are within the same domain (intra-domain contact) if
among the domain intervals exists an interval that fully overlaps both I1
and I2. Otherwise the contact is considered to be inter-domain. 'domain'
must contain only non-overlapping intervals.

The distance between I1 and I2 is the absolute distance between the centers
of these intervals, i.e.: '|(start1 + end1 - start2 - end2) / 2|'.

The range of distances for which the distribution is calculated is defined
by 'breaks' argument. For example: 'breaks=c(x1, x2, x3, x4)' represents
three different intervals (bins): (x1, x2], (x2, x3], (x3, x4].

If 'include.lowest' is 'TRUE' the the lowest value will be included in the
first interval, i.e. in [x1, x2]
}
\examples{
\dontshow{
options(gmax.processes = 2)
}

gdb.init_examples()

src <- rbind(
    gintervals(1, 10, 100),
    gintervals(1, 200, 300),
    gintervals(1, 400, 500),
    gintervals(1, 600, 700),
    gintervals(1, 7000, 9100),
    gintervals(1, 9000, 18000),
    gintervals(1, 30000, 31000),
    gintervals(2, 1130, 15000)
)

domain <- rbind(
    gintervals(1, 0, 483000),
    gintervals(2, 0, 300000)
)

gcis_decay("rects_track", 50000 * (1:10), src, domain)

}
\seealso{
\code{\link{gdist}}, \code{\link{gtrack.2d.import_contacts}}
}
\keyword{~contacts}
