% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/minimexico.R
\name{minimexico}
\alias{minimexico}
\title{Make a tile grid map of Mexico}
\usage{
minimexico(estados, estados_colors, border_colors = rep("white", 32),
  estados_names = TRUE, estados_name_colors = rep("white", 32),
  estados_name_cex = 1, font = NULL)
}
\arguments{
\item{estados}{A vector of Mexican state postal abbreviations. This vector must be
some permutation of \code{mexico_abb}.}

\item{estados_colors}{A vector of "colors" in the R sense. For example strings
(\code{"blue"}), hex codes (\code{"#D0C7B9"}), etc. The ith color in this
vector will be the color of square that represents the ith element of
\code{estados}.}

\item{border_colors}{Like \code{estados_colors} but specifying the border
of the square.}

\item{estados_names}{Should the postal codes for each state be displayed in the
center of the state? The default value is \code{TRUE}.}

\item{estados_name_colors}{Like \code{estados_colors} but specifying the color
of the text displayed in each state.}

\item{estados_name_cex}{The size of the text displayed inside of each state.}

\item{font}{The font of the text displayed inside of each state. The values
\code{"serif"}, \code{"sans"}, and \code{"mono"} are safest to use. Use
other fonts at your own risk. If \code{NULL} a sans-style font will be used.}
}
\description{
Make a tile grid map of Mexico
}
\examples{
\dontrun{
 minimexico(mexico_abb, 1:32)
}
}

