% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3methods.R
\name{plot.miniPCH}
\alias{plot.miniPCH}
\alias{summary.miniPCH}
\alias{print.miniPCH}
\alias{autoplot.miniPCH}
\title{miniPCH class}
\usage{
\method{plot}{miniPCH}(
  x,
  ...,
  what = c("d", "s", "h"),
  from,
  to,
  mfrow = c(1, length(what)),
  n = 1001
)

\method{summary}{miniPCH}(object, ...)

\method{print}{miniPCH}(x, ...)

\method{autoplot}{miniPCH}(object, ..., what = c("d", "s", "h"), from, to, n = 1001)
}
\arguments{
\item{x}{miniPCH object}

\item{...}{passed on to base::plot}

\item{what}{what to plot ("d", "p", "q", "h", "ch", "s")}

\item{from}{lower x-Axis limit}

\item{to}{upper x-Axis limit}

\item{mfrow}{plot layout defaults to all plots in one row}

\item{n}{number of points for interpolation}

\item{object}{miniPCH object}
}
\value{
for plot: NULL, invisibly

for summary: a list

for print: the printed text, invisibly

for autoplot: a ggplot object
}
\description{
miniPCH class
}
\details{
The layout in print uses the mfrow argument to par and defaults to all plots
in one row. The layout can be overwritten by passing the mfrow argument, that
is passed as is to an internal call to par.
}
\section{Functions}{
\itemize{
\item \code{summary(miniPCH)}: summary

\item \code{print(miniPCH)}: printing

\item \code{autoplot(miniPCH)}: autoplot with ggplot

}}
\examples{
my_pch <- pch_functions(c(0, 3), c(2, 0.1))

Tint <- c(0,3)
Q <- array(
  c(
    -0.3,  0  , 0,
    0.2, -0.4, 0,
    0.1,  0.4, 0,

    -0.3,  0  , 0,
    0.2, -0.2, 0,
    0.1,  0.2, 0
  ), dim=c(3,3,2)
)

pi <- c(1,0,0)
abs <- c(0,0,1)

my_obj <- multistate_functions(Tint, Q, pi, abs)

plot(my_pch)
summary(my_pch)
print(my_pch)

plot(my_obj)
summary(my_obj)
print(my_obj)

library(ggplot2)
autoplot(my_pch)
autoplot(my_obj)
}
