% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/internal.R
\name{repoPrefix}
\alias{repoPrefix}
\title{Get the path to the repo directory containing the package files.}
\usage{
repoPrefix(type, Rversion)
}
\arguments{
\item{type}{character, indicating the type of package to download and
install. See \code{\link[=install.packages]{install.packages()}}.}

\item{Rversion}{Version of R (only used if \code{type} is not \code{source}.) Defaults to \link{R.version}, but this can be specified as any of the following formats:
\itemize{
\item a character string with the two digit R version, e.g. "3.1"
\item a list with components \code{major} and \code{minor}
\item the result of \code{\link[=getRversion]{getRversion()}}
\item the result of \link{R.version}
}}
}
\value{
The file path to the package files directory.
}
\description{
Get the path to the repo directory containing the package files.
}
\note{
Not all versions of R are compatible with with all package types (e.g.,
\code{mac.binary.el-capitan} is only valid for R > 3.4.0).
}
\section{Repo folder structure}{


A repository has two main folders, one for source packages, and the other
for binary packages.  Inside the binary package folder, \code{bin}, you will find
subfolders for Windows as well as the various OSX binaries.

\code{+- Root}

\code{...+- src/contrib}

\code{......+- PACKAGES}

\code{..+- bin}

\code{.......+- windows/contrib/version}

\code{..........+- PACKAGES}

\code{.......+-  macosx/contrib/version}

\code{..........+-  PACKAGES}

\code{.......+-  macosx/mavericks/contrib/version}

\code{..........+-  PACKAGES}

\code{.......+-  macosx/leopard/contrib/version}

\code{..........+- PACKAGES}
}

\keyword{Internal}
