% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pkgDep.R
\name{pkgAvail}
\alias{pkgAvail}
\title{Reads available packages from CRAN repository.}
\usage{
pkgAvail(
  repos = getOption("repos"),
  type = "source",
  Rversion = R.version,
  quiet = FALSE,
  filters = NULL
)
}
\arguments{
\item{repos}{URL(s) of the 'contrib' sections of the repositories, e.g.
\code{"https://cran.us.r-project.org"}. Passed to \code{\link[=available.packages]{available.packages()}}}

\item{type}{Possible values are (currently) "source", "mac.binary" and
"win.binary": the binary types can be listed and downloaded but not
installed on other platforms.  Passed to \code{\link[=download.packages]{download.packages()}}.}

\item{Rversion}{Version of R (only used if \code{type} is not \code{source}.) Defaults to \link{R.version}, but this can be specified as any of the following formats:
\itemize{
\item a character string with the two digit R version, e.g. "3.1"
\item a list with components \code{major} and \code{minor}
\item the result of \code{\link[=getRversion]{getRversion()}}
\item the result of \link{R.version}
}}

\item{quiet}{If TRUE, suppresses warnings}

\item{filters}{passed to \link[utils:available.packages]{utils::available.packages}}
}
\description{
This is a thin wrapper around \code{\link[utils:available.packages]{utils::available.packages()}}.  If the argument
\code{path} is supplied, then the function attempts to read from a local
repository, otherwise attempts to read from a CRAN mirror at the \code{repos} url.
}
\seealso{
\code{\link[=pkgDep]{pkgDep()}}
}
\concept{create repo functions}
