% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exploreDAG.R
\name{exploreDAG}
\alias{exploreDAG}
\title{Compares data with proposed DAG}
\usage{
exploreDAG(mdag, data)
}
\arguments{
\item{mdag}{The DAG, specified as a string using \link[dagitty]{dagitty}
syntax}

\item{data}{A data frame containing all the variables stated in the DAG. All
ordinal variables must be integer-coded and all categorical variables must
be dummy-coded.}
}
\value{
A message indicating whether the relationships between fully observed
variables in the specified dataset are consistent with the proposed DAG
}
\description{
Explore whether relationships between fully observed variables in the
specified dataset are consistent with the proposed directed acyclic graph
(DAG) using \link[dagitty]{localTests} functionality.
}
\examples{
exploreDAG(mdag="matage -> bmi7 mated -> matage mated -> bmi7
                 sep_unmeas -> mated sep_unmeas -> r",
           data=bmi)
}
