% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01-correct_haemoglobin.R
\name{correct_hb}
\alias{correct_hb}
\title{Correct haemoglobin based on altitude and/or smoking status}
\usage{
correct_hb(hb = NULL, alt = NULL, smoke = NULL)
}
\arguments{
\item{hb}{A numeric value or numeric vector of serum haemoglobin
concentration/s in grams per litre (g/l)}

\item{alt}{Altitude, in metres, above sea level}

\item{smoke}{Simple integer code for smoking status classification:
0 = non-smoker; 1 = any smoker or half packet up to less than 1 packet a
day; 2 = 1 up to less than 2 packets a day; 3 = 2 or more packets a day.}
}
\value{
A numeric value or numeric vector of corrected serum haemoglobin
concentration/s in grams per litre (g/l)
}
\description{
Correct haemoglobin based on altitude and/or smoking status
}
\examples{
correct_hb(hb = mnData$hb[1], alt = mnData$altitude[1], smoke = 1)

}
\author{
Ernest Guevarra
}
