% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checks.R
\name{check_unique_keys}
\alias{check_unique_keys}
\title{Check Uniqueness of Records by Key}
\usage{
check_unique_keys(data, metacore, dataset_name = deprecated())
}
\arguments{
\item{data}{Dataset to check}

\item{metacore}{metacore object that only contains the specifications for the
dataset of interest.}

\item{dataset_name}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} Optional string to
specify the dataset that is being built. This is only needed if the metacore
object provided hasn't already been subsetted.\cr
Note: Deprecated in version 0.2.0. The \code{dataset_name} argument will be removed
in a future release. Please use \code{metacore::select_dataset} to subset the
\code{metacore} object to obtain metadata for a single dataset.}
}
\value{
message if the key uniquely identifies each dataset record, and error otherwise
}
\description{
This function checks the uniqueness of records in the dataset by key using
\code{get_keys} from the metacore package. If the key uniquely identifies each
record the function will print a message stating everything is as expected.
If records are not uniquely identified an error will explain the duplicates.
}
\examples{
library(haven)
library(metacore)
library(magrittr)
load(metacore_example("pilot_ADaM.rda"))
spec <- metacore \%>\% select_dataset("ADSL")
data <- read_xpt(metatools_example("adsl.xpt"))
check_unique_keys(data, spec)
}
