% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filters.R
\name{filter_global_mv}
\alias{filter_global_mv}
\title{Filter Features based on the absolute number or fraction of samples it was found in}
\usage{
filter_global_mv(data, min_found = 0.5, fraction = TRUE)
}
\arguments{
\item{data}{A tidy tibble created by \code{metamorphr::read_featuretable()}.}

\item{min_found}{In how many samples must a Feature be found? If \code{fraction == TRUE}, a value between 0 and 1 (\emph{e.g.}, 0.5 if a Feature must be found in at least half the samples). If \code{fraction == FALSE} the absolute maximum number of samples (\emph{e.g.}, 5 if a specific Feature must be found in at least 5 samples).}

\item{fraction}{Either \code{TRUE} or \code{FALSE}. Should \code{min_found} be the absolute number of samples or a fraction?}
}
\value{
A filtered tibble.
}
\description{
Filters features based on the number or fraction of samples they are found in.
This is usually one of the first steps in metabolomics data analysis and often already performed when the feature table is first created from the raw spectral files..
}
\examples{
# Example 1: A feature must be found in at least 50 \% of the samples
toy_metaboscape \%>\%
  filter_global_mv(min_found = 0.5)

# Example 2: A feature must be found in at least 8 samples
toy_metaboscape \%>\%
  filter_global_mv(min_found = 8, fraction = FALSE)
}
