% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_sp_A_ts.R
\name{plot_sp_A_ts}
\alias{plot_sp_A_ts}
\title{Plot sample time series from a portfolio simulation}
\usage{
plot_sp_A_ts(
  X,
  ylim,
  x_axis = TRUE,
  y_axis = TRUE,
  rate = FALSE,
  lwd = 1.7,
  y_axis_ticks = NULL,
  start_new_plots = 1,
  labels = NULL,
  burn = 30,
  add_lm = FALSE,
  cols,
  ...
)
}
\arguments{
\item{X}{Object to plot. Should be a list of outputs from
\code{\link{meta_sim}}.}

\item{ylim}{Y axis limits.}

\item{x_axis}{Should an x axis be added?}

\item{y_axis}{Should a y axis be added?}

\item{rate}{If \code{TRUE} then the first difference (rate of change) will be
plotted. If \code{FALSE} then the raw data will be plotted.}

\item{lwd}{Line width of the lines.}

\item{y_axis_ticks}{Location of the y-axis tick marks, if you want to specify
them.}

\item{start_new_plots}{On which elements of the list \code{X} should new
panels be started? A numeric vector.}

\item{labels}{Labels for the panels.}

\item{burn}{Burn in period to discard.}

\item{add_lm}{Add a regression trend line?}

\item{cols}{Colours for the lines. A vector of character.}

\item{...}{Anything else to pass to \code{\link[graphics]{plot.default}}}
}
\value{
A plot, possibly with multiple panels.
}
\description{
Plot sample time series from a portfolio simulation
}
\examples{
w_plans <- list()
w_plans[[1]] <- c(5, 1000, 5, 1000, 5, 5, 1000, 5, 1000, 5)
w_plans[[2]] <- c(5, 5, 5, 1000, 1000, 1000, 1000, 5, 5, 5)
w_plans[[3]] <- c(rep(1000, 4), rep(5, 6))
w_plans[[4]] <- rev(w_plans[[3]])
w <- list()
for(i in 1:4) { # loop over plans
 w[[i]] <- list()
 for(j in 1:2) { # loop over trials
   w[[i]][[j]] <- matrix(w_plans[[i]], nrow = 1)
 }
}

cons_arma_ts <- list()
arma_env_params <- list(mean_value = 16, ar = 0.1, sigma_env = 2, ma = 0)
for(i in 1:4) {
  use_cache <- ifelse(i == 1, FALSE, TRUE)
  cons_arma_ts[[i]] <- meta_sim(b = w[[i]][[1]], n_pop = 10, env_params =
    arma_env_params, env_type = "arma", assess_freq = 5,
    use_cache = use_cache)
}
cols <- RColorBrewer::brewer.pal(5, "Dark2")
par(mfrow = c(2, 1))
plot_sp_A_ts(cons_arma_ts, ylim = c(0000, 12400),
  start_new_plots = c(1, 3),
  labels = c("Balanced response diversity",
    "ignore", "Unbalanced response diversity", "ignore"), cols = cols)
}
