% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/es_from_ANOVA_statistics.R
\name{es_from_student_t}
\alias{es_from_student_t}
\title{Convert a Student's t-test value to several effect size measures}
\usage{
es_from_student_t(
  student_t,
  n_exp,
  n_nexp,
  smd_to_cor = "viechtbauer",
  reverse_student_t
)
}
\arguments{
\item{student_t}{Student's t-test value.}

\item{n_exp}{number of participants in the experimental/exposed group.}

\item{n_nexp}{number of participants in the non-experimental/non-exposed group.}

\item{smd_to_cor}{formula used to convert the \code{student_t} value into a coefficient correlation (see details).}

\item{reverse_student_t}{a logical value indicating whether the direction of generated effect sizes should be flipped.}
}
\value{
This function estimates and converts between several effect size measures.

\tabular{ll}{
\code{natural effect size measure} \tab D + G\cr
\tab \cr
\code{converted effect size measure} \tab OR + R + Z\cr
\tab \cr
\code{required input data} \tab See 'Section 11. ANOVA statistics, Student's t-test, or point-bis correlation'\cr
\tab https://metaconvert.org/html/input.html\cr
\tab \cr
}
}
\description{
Convert a Student's t-test value to several effect size measures
}
\details{
This function converts the Student's t-test value into a Cohen's d (D) and Hedges' g (G),
Odds ratio (OR) and correlation coefficients (R/Z) are then converted from the Cohen's d.

\strong{To estimate a Cohen's d} the formula used is (table 12.1 in Cooper):
\deqn{cohen\_d = student\_t * \sqrt{\frac{(n\_exp+n\_nexp)}{n\_exp*n\_nexp}}}

\strong{To estimate other effect size measures},
calculations of the \code{\link{es_from_cohen_d}()} are applied.
}
\examples{
es_from_student_t(student_t = 2.1, n_exp = 20, n_nexp = 22)
}
\references{
Cooper, H., Hedges, L.V., & Valentine, J.C. (Eds.). (2019). The handbook of research synthesis and meta-analysis. Russell Sage Foundation.
}
