% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/confRegion.R
\name{confRegion}
\alias{confRegion}
\title{Confidence regions (ellipses) for Monte Carlo estimates}
\usage{
confRegion(mcse.obj, which = c(1,2), level = .95)
}
\arguments{
\item{mcse.obj}{The list returned by the mcse.multi or mcse.initseq command, or an mcmcse class object.}

\item{which}{Integer vector of length 2 indicating the component for which to make the confidence
ellipse. Chooses the first two by default.}

\item{level}{confidence level for the ellipse.}
}
\value{
Returns a matrix of x and y coordinates for the ellipse. Use plot function on the matrix
to plot the ellipse.
}
\description{
Constructs confidence regions (ellipses) from the Markov chain output for the features of interest
Function uses the ellipse package.
}
\examples{

## Bivariate Normal with mean (mu1, mu2) and covariance sigma
n <- 1e3
mu <- c(2, 50)
sigma <- matrix(c(1, 0.5, 0.5, 1), nrow = 2)

out <- BVN_Gibbs(n, mu, sigma)

mcerror <- mcse.multi(out, blather = TRUE)

## Plotting the ellipse
plot(confRegion(mcerror), type = 'l')
}
