% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/citation.R
\name{extract_field}
\alias{extract_field}
\title{Extract field value from BibTeX entry}
\usage{
extract_field(entry, field)
}
\arguments{
\item{entry}{Character string containing a BibTeX entry}

\item{field}{Name of the field to extract (e.g., "title", "author", "year")}
}
\value{
Character string containing the field value if found, NA if the field is not present
}
\description{
Extracts the value of a specified field from a BibTeX entry string using regular expressions.
The function is case-insensitive and handles various spacing patterns around the field
delimiter.
}
\details{
The function searches for patterns of the form "field = \{value\}" in the BibTeX entry,
ignoring case and allowing for variable whitespace around the equals sign. The value
is expected to be enclosed in curly braces.
}
\keyword{internal}
