% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{create_test_grid}
\alias{create_test_grid}
\title{Create a Regular Test Grid of Coordinates}
\usage{
create_test_grid(range = c(-1, 1), spacing = 0.1)
}
\arguments{
\item{range}{Numeric vector of length 2 giving the x and y limits
of the grid (default = \code{c(-1, 1)}).}

\item{spacing}{Numeric. Distance between adjacent grid points
along each axis (default = \code{0.1}).}
}
\value{
A numeric matrix with two columns (\code{x}, \code{y}) containing
the coordinates of the grid points.
}
\description{
Generates a 2D grid of equally spaced points, useful for testing
fisheye transformations and other spatial warping functions.
}
\examples{
# Create a grid from -1 to 1 with spacing 0.25
grid <- create_test_grid(range = c(-1, 1), spacing = 0.25)
head(grid)

}
\seealso{
\code{\link[=plot_fisheye_fgc]{plot_fisheye_fgc()}}, \code{\link[=fisheye_fgc]{fisheye_fgc()}}
}
