% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mf_graticule.R
\name{mf_graticule}
\alias{mf_graticule}
\title{Plot graticules}
\usage{
mf_graticule(
  x,
  col,
  lwd = 1,
  lty = 1,
  expandBB = rep(0, 4),
  label = TRUE,
  pos = c("top", "left"),
  cex = 0.7,
  add = TRUE
)
}
\arguments{
\item{x}{object of class \code{sf}, \code{sfc} or \code{SpatRaster}}

\item{col}{graticules and label color}

\item{lwd}{graticules line width}

\item{lty}{graticules line type}

\item{expandBB}{fractional values to expand the bounding box with, in each
direction (bottom, left, top, right)}

\item{label}{whether to add labels (TRUE) or not (FALSE)}

\item{pos}{labels positions ("bottom", "left", "top" and / or "right")}

\item{cex}{labels size}

\item{add}{whether to add the layer to an existing plot (TRUE) or
not (FALSE)}
}
\value{
An (invisible) layer of graticules is returned (LINESTRING).
}
\description{
Display graticules and labels on a map.
}
\section{Use of graticules}{

From \code{\link[sf:st_graticule]{st_graticule}}:
"In cartographic visualization, the use of graticules is not advised, unless
the graphical output will be used for measurement or navigation, or the
direction of North is important for the interpretation of the content, or
the content is intended to display distortions and artifacts created by
projection. Unnecessary use of graticules only adds visual clutter but
little relevant information. Use of coastlines, administrative boundaries
or place names permits most viewers of the output to orient themselves
better than a graticule."
}

\examples{
mtq <- mf_get_mtq()
mf_map(mtq, expandBB = c(0, .1, .1, 0))
mf_graticule(mtq)

mf_graticule(
  x = mtq,
  col = "coral4",
  lwd = 2,
  lty = 2,
  expandBB = c(.1, 0, 0, .1),
  label = TRUE,
  pos = c("right", "bottom"),
  cex = .8,
  add = FALSE
)
mf_map(mtq, add = TRUE)
}
