% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{estimate_autotheta_1subpop_individuals}
\alias{estimate_autotheta_1subpop_individuals}
\title{Estimate autosomal theta from individuals}
\usage{
estimate_autotheta_1subpop_individuals(
  individuals,
  return_estimation_info = FALSE
)
}
\arguments{
\item{individuals}{Individuals to get haplotypes for.}

\item{return_estimation_info}{Whether to return the quantities used to estimate \code{theta}}
}
\value{
List:
\itemize{
\item \code{theta}
\itemize{
\item \code{estimate}: Vector of length 1 containing estimate of theta or NA if it could not be estimated
\item \code{error}: true if an error happened, false otherwise
\item \code{details}: contains description if an error happened
\item \code{estimation_info}: If \code{return_estimation_info = true}: a list with information used to estimate \code{theta}. Else \code{NULL}.
}
}
}
\description{
Estimate autosomal theta for one subpopulation given a list of individuals.
}
\details{
Assumes that \code{\link[=pedigrees_all_populate_autosomal]{pedigrees_all_populate_autosomal()}} was used first to populate autosomal genotypes.
}
