% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/04-catalogue_functions.R
\name{valueType_convert_to_typeof}
\alias{valueType_convert_to_typeof}
\title{Convert valueType into its corresponding typeof and class in R representation}
\usage{
valueType_convert_to_typeof(valueType)
}
\arguments{
\item{valueType}{A character string of the valueType to convert.}
}
\value{
A character vector, named 'typeof' and 'class'.
}
\description{
The function converts a given valueType string into its corresponding typeof
representation. This function is particularly useful for mapping different
data types to their equivalent value types in contexts such as data modeling
and data dictionary creation. The class is provided and allows for more
specific conversions when necessary.
}
\details{
The valueType is a declared property of a variable that is required in
certain functions to determine handling of the variables. Specifically,
valueType refers to the
\href{https://opaldoc.obiba.org/en/dev/variables-data.html#value-types}{OBiBa data type of a variable}.
The valueType is specified in a data dictionary in a column 'valueType' and
can be associated with variables as attributes. Acceptable valueTypes
include 'text', 'integer', 'decimal', 'boolean', datetime', 'date'. The full
list of OBiBa valueType possibilities and their correspondence with R data
types are available using \link{valueType_list}. The valueType can be used to
coerce the variable to the corresponding data type.
}
\examples{
{

valueType_convert_to_typeof(valueType = NA)
valueType_convert_to_typeof(valueType = "text")
valueType_convert_to_typeof(valueType = "date")
valueType_convert_to_typeof(valueType = "decimal")

}

}
