% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cliBIOME.R
\name{cliBIOMEGrid}
\alias{cliBIOMEGrid}
\title{Vegetation Classifier Using the BIOME Model}
\usage{
cliBIOMEGrid(
  rs.temp,
  rs.prec,
  rs.bsdf,
  rl.elv,
  sc.year = 2000,
  rl.MSMC = 150,
  aprchTEMP = c("hip", "tsi", "const"),
  aprchPREC = c("tsi", "hip", "const"),
  aprchBSDF = c("hip", "const"),
  dvTEMP = rep(0.7, 12),
  dvPREC = rep(0.7, 12),
  verbose = FALSE,
  filename = "",
  ...
)
}
\arguments{
\item{rs.temp}{multi-layer Raster*/SpatRaster object with one-year time series of monthly mean air temperature
(in °C)}

\item{rs.prec}{multi-layer Raster*/SpatRaster object with one-year time series of monthly precipitation sum
(in mm)}

\item{rs.bsdf}{multi-layer Raster*/SpatRaster object with one-year time series of monthly mean relative sunshine
duration (dimensionless)}

\item{rl.elv}{single-layer Raster*/SpatRaster object with the elevation values (in meters above sea level)}

\item{sc.year}{'numeric' scalar with the value of the year (using astronomical year numbering)}

\item{rl.MSMC}{'numeric' scalar or single-layer Raster*/SpatRaster object with the value/values of the maximum
soil moisture capacity (aka 'bucket size') (in mm)}

\item{aprchTEMP}{'character' vector of length 1 that indicates the scheme used to generate daily values of the
daily mean air temperature for a specific year. Valid values are as follows: \cr
(a) \code{'hip'} -
this scheme applies the mean-preserving 'harmonic' interpolation method of Epstein (1991) to the values of
monthly mean air temperature in order to generate daily values; \cr
(b) \code{'tsi'} -
this scheme uses an iterative interpolation technique (Lüdeke et al. 1994) to time series of the monthly mean
air temperature, in order to generate a synthetic time series of the selected meteorological variable at a
temporal resolution that is higher than the daily scale; finally, this synthetic time series is upscaled to a
daily resolution; \cr
(c) \code{'const'} -
this scheme is assumed that values of the daily mean air temperature are constant within each month.}

\item{aprchPREC}{'character' vector of length 1 that indicates the scheme to generate daily values of the
daily precipitation sum. Valid values are as follows: \cr
(a) \code{'tsi'} -
this scheme uses an iterative interpolation technique (Lüdeke et al. 1994) to time series of the monthly mean
precipitation intensity, in order to generate a synthetic time series of the selected meteorological variable
at a temporal resolution that is higher than the daily scale; finally, this synthetic time series is upscaled
to a daily resolution; \cr
(b) \code{'hip'} -
this scheme applies the mean-preserving 'harmonic' interpolation method of Epstein (1991) to the values of
monthly mean precipitation intensity in order to generate daily values; \cr
(c) \code{'const'} -
this scheme is assumed that values of the daily precipitation sum are constant within each month (the monthly
precipitation sum is divided equally across each day of the month).}

\item{aprchBSDF}{'character' vector of length 1 that indicates the scheme used to generate daily values of the
daily fractional sunshine duration for a specific year. Valid values are as follows: \cr
(a) \code{'hip'} -
this scheme applies the mean-preserving 'harmonic' interpolation method of Epstein (1991) to the values of
monthly mean relative sunshine duration in order to generate daily values; \cr
(b) \code{'const'} -
this scheme is assumed that values of the daily relative sunshine duration are constant within each month.}

\item{dvTEMP}{'numeric' vector of length 12 with monthly values of the damping variable for the air temperature
data.}

\item{dvPREC}{'numeric' vector of length 12 with monthly values of the damping variable for the precipitation data.}

\item{verbose}{'logical' scalar that indicates whether or not values of the bioclimatic indices used should be
added to the output.}

\item{filename}{output filename}

\item{...}{additional arguments passed on to \code{\link[terra]{writeRaster}}}
}
\value{
Depending on the setting, a SpatRaster object with one or more layers where the numeric integers encoding
    the biome type are stored at the last layer, while the additional layers contain the values of bioclimatic
    indices used. The meaning of integers is given in the data frame \code{\link[macroBiome]{vegClsNumCodes}}. If
    \code{verbose = FALSE}, the return object is a single-layer SpatRaster object with numeric integers encoding
    the biome type.
}
\description{
Calculates the values of bioclimatic indices used in the BIOME model developed by Prentice et al.
    (1992), and designates the biome type using these values, for a given region and year/epoch, by using the
    monthly time series of temperature, precipitation and relative sunshine duration, and the elevation data.
}
\details{
See \code{\link[macroBiome]{cliBIOMEPoints}}.
}
\note{
The objects \code{'rs.temp'}, \code{'rs.prec'} and \code{'rs.bsdf'} must be 12-layer Raster*/SpatRaster
    objects, while the object \code{'rl.elv'} has to be a single-layer Raster*/SpatRaster object. The object
    \code{'rl.MSMC'} must be either a single positive number (a universal bucket size) or a single-layer
    Raster*/SpatRaster object (a regionally-specified bucket size). These Raster*/SpatRaster objects must have the
    same bounding box, projection, and resolution. The object \code{'sc.year'} has to be a single integer number.
}
\examples{
\donttest{
library(raster)

# Loading mandatory data for the Example 'Climate Normal Grid'
data(inp_exClnrGrid)
inp_exClnrGrid <- lapply(inp_exClnrGrid, crop, extent(20.15, 20.25, 46.25, 46.35))

# Designate the biome type (using the related bioclimatic indices), with default settings,
# at a grid cell near Szeged, Hungary (46.3N, 20.2E) (for the normal period 1981-2010)
with(inp_exClnrGrid, {
year <- trunc(mean(seq(1981, 2010)))
rs.BIOME <- cliBIOMEGrid(temp, prec, bsdf, elv, sc.year = year, verbose = TRUE)
rs.BIOME
})
}

}
\references{
\cite{Epstein ES (1991) On Obtaining Daily Climatological Values from Monthly Means. J Clim 4(3):365–368.
    \doi{10.1175/1520-0442(1991)004<0365:OODCVF>2.0.CO;2}}

\cite{Lüdeke MKB, Badeck FW, Otto RD, Häger C, Dönges S, Kindermann J, Würth G, Lang T, Jäkel U, Klaudius A,
    Ramge P, Habermehl S, Kohlmaier GH (1994) The Frankfurt Biosphere Model: A global process-oriented model of
    seasonal and long-term CO2 exchange between terrestrial ecosystems and the atmosphere. I. Model description
    and illustrative results for cold deciduous and boreal forests. Clim Res 4(2):143-166. \doi{10.3354/cr004143}}

\cite{Prentice IC, Cramer W, Harrison SP, Leemans R, Monserud RA, Solomon AM (1992) A Global Biome Model Based on
    Plant Physiology and Dominance, Soil Properties and Climate. J Biogeogr 19(2):117–134. \doi{10.2307/2845499}}
}
