% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rMethods.R
\name{loadScoreFromFile}
\alias{loadScoreFromFile}
\title{Load score from file}
\usage{
loadScoreFromFile(filepath, header = TRUE, ...)
}
\arguments{
\item{filepath}{optional: location of file on disk. If not provided, a file picker dialogue box will be opened.}

\item{header}{does the file contain a header line (defaut to \code{TRUE})}

\item{...}{optional: use arguments from read.csv}
}
\value{
A data.frame. Rownames correspond to the first column, usually Letters. Associated numerical scores are in the second column. If probabilities are provided, 
they will be loaded too and presumed to be in the third column
}
\description{
Reads a csv file containing an alphabet, the associated scores, and eventually the associated probabilities.
}
\details{
The file should contains a header and 2 or 3 columns : first column the letters, second column the associated scores, optional third column associated probabilities. Letters should be unique and probabilities should sum to 1.
}
